import request from '@/utils/request'

// 查询油气数智化-产品列表
export function listCb(query) {
  return request({
    url: '/system/cb/list',
    method: 'get',
    params: query
  })
}

// 查询油气数智化-产品详细
export function getCb(id) {
  return request({
    url: '/system/cb/' + id,
    method: 'get'
  })
}

// 新增油气数智化-产品
export function addCb(data) {
  return request({
    url: '/system/cb',
    method: 'post',
    data: data
  })
}

// 修改油气数智化-产品
export function updateCb(data) {
  return request({
    url: '/system/cb',
    method: 'put',
    data: data
  })
}

// 删除油气数智化-产品
export function delCb(id) {
  return request({
    url: '/system/cb/' + id,
    method: 'delete'
  })
}
