import request from '@/utils/request'

// 查询油气数智化-分类列表
export function listZb(query) {
  return request({
    url: '/system/zb/list',
    method: 'get',
    params: query
  })
}

// 查询油气数智化-分类列表
export function listZbxlk(query) {
  return request({
    url: '/system/zb/listxlk',
    method: 'get',
    params: query
  })
}

// 查询油气数智化-分类详细
export function getZb(id) {
  return request({
    url: '/system/zb/' + id,
    method: 'get'
  })
}

// 新增油气数智化-分类
export function addZb(data) {
  return request({
    url: '/system/zb',
    method: 'post',
    data: data
  })
}

// 修改油气数智化-分类
export function updateZb(data) {
  return request({
    url: '/system/zb',
    method: 'put',
    data: data
  })
}

// 删除油气数智化-分类
export function delZb(id) {
  return request({
    url: '/system/zb/' + id,
    method: 'delete'
  })
}
