package com.qianhe.framework.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.common.core.domain.model.MpLoginUser;
import com.qianhe.framework.util.UserInfoUtil;
import com.qianhe.framework.web.service.MpTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import com.qianhe.common.core.domain.model.LoginUser;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.framework.web.service.TokenService;

/**
 * token过滤器 验证token有效性
 *
 * @author qinahe
 */
@Component
public class JwtAuthenticationTokenFilter extends OncePerRequestFilter
{
    @Autowired
    private TokenService tokenService;

    @Autowired
    private MpTokenService mpTokenService;

    @Autowired
    UserInfoUtil userInfoUtil;

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain)
            throws ServletException, IOException
    {
        //小程序登录
        String mpToken = mpTokenService.getToken(request);
        if (StringUtils.isNotEmpty(mpToken)) {
            MpLoginUser mpLoginUser = mpTokenService.getMpLoginUser(mpToken);
            if (StringUtils.isNotNull(mpLoginUser)) {
                mpLoginUser.setType("1");
                userInfoUtil.setMpLoginUser(mpLoginUser);
                mpTokenService.verifyToken(mpLoginUser);
                UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(mpLoginUser, null, null);
                authenticationToken.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication(authenticationToken);
            }
        }

        //PC端登录
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (StringUtils.isNotNull(loginUser) && StringUtils.isNull(SecurityUtils.getAuthentication()))
        {
            loginUser.setType("2");
            SecurityUtils.setLoginUser1(loginUser);
            tokenService.verifyToken(loginUser);
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(loginUser, null, loginUser.getAuthorities());
            authenticationToken.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication(authenticationToken);
        }
        chain.doFilter(request, response);
    }
}
