package com.qianhe.system.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.system.domain.WaterUserAddress;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class WaterUserVo {

    /** 主键 */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 昵称 */
    @Excel(name = "昵称")
    private String nickName;

    /** 手机号 */
    @Excel(name = "手机号")
    private Long phoneNum;

    /** 站点名称 */
    @Excel(name = "站点名称")
    private String stationName;

    /** 用户类型 */
    @Excel(name = "用户类型")
    private String userType;

    /** 性别(1男0女) */
    @Excel(name = "性别", combo = {"男","女","未知"}, readConverterExp = "1=男,0=女,2=未知")
    private Long userGender;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 状态(1逻辑删除) */
    private String status;

    /** 微信小程序open_id */
    private String openId;

    private List<WaterUserAddress> waterUserAddressList;
}
