package com.qianhe.system.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.system.domain.WaterOrderGoods;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class WaterOrderVo {

    private Long id;

    /** 序号 */
    private Integer xh;

    /** 用户id */
    private Long userId;

    /** 用户名字 */
    @Excel(name = "下单用户", needMerge = true)
    private String userName;

    /** 订单编号(生成规则当前年月日+当天下单0001开始+随机生成4位英文字母) */
    @Excel(name = "订单编号", needMerge = true)
    private String orderNum;

    /** 用户手机号 */
    @Excel(name = "用户电话", needMerge = true)
    private Long userPhone;

    /** 用户省 */
    private String userProvince;

    /** 用户城市 */
    private String userCity;

    /** 用户区 */
    private String userArea;

    /** 用户详细地址 */
    private String userAddress;

    /** 站点id */
    private Long stationId;

    /** 站点名字 */
    @Excel(name = "站点名字", needMerge = true)
    private String stationName;

    /** 站点手机号 */
    private Long stationPhone;

    /** 站点省份 */
    private String stationProvince;

    /** 站点城市 */
    private String stationCity;

    /** 站点市区 */
    private String stationArea;

    /** 站点详细地址 */
    private String stationAddress;

    /** 支付方式(1银行2水票) */
    @Excel(name = "支付方式", readConverterExp = "1=银行支付,2=水票支付", needMerge = true)
    private Integer payType;

    /** 订单商品分类（1商品页，2购物车） */
    private Integer orderGoodsType;

    /** 订单状态(1待付款2待接单3进行中4已完成5已取消6已退款) */
    @Excel(name = "订单状态", readConverterExp = "1=待付款,2=待接单,3=进行中,4=已完成,5=已取消,6=已退款", needMerge = true)
    private Integer orderState;

    /** 送水工完成状态（0未完成，1已完成，2已退款） */
    private Integer completeState;

    /** 用户确认状态（0未确认，1确认收货，2确认退款） */
    private Integer confirmState;

    /** 付款状态(0未付款1已付款) */
    private Integer payState;

    /** 银行返回支付成功code */
    private String payNum;

    /** 取消原因 */
    private String cancelResult;

    /** 用户地址id */
    private Long userAddressId;

    /** 收货人名字 */
    private String name;

    /** 省 */
    private String province;

    /** 市 */
    private String city;

    /** 区 */
    private String area;

    /** 详细地址 */
    private String address;

    /** 收货地址经度 */
    private double lon;

    /** 收货地址纬度 */
    private double lat;

    /** 收货人手机号 */
    private Long mobile;

    /** 送货时间 */
    private String delieverTime;

    /** 送水工名字 */
    private String delieverName;

    /** 送水工电话 */
    private String delieverMobile;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss",needMerge = true)
    private Date createTime;

    /** 创建人 */
    private String createUser;

    /** 送达时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date delieverOver;

    /** 收货时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date takeTime;

    /** 完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date finishTime;

    /** 备注 */
    @Excel(name = "备注", needMerge = true)
    private String remark;

    /** 商品总价 */
    private BigDecimal goodsVal;

    /** 订单类型（1普通订单2退款订单） */
    private Integer orderType;

    /** 退款原因 */
    private String returnOrderResult;

    /** 开始时间 */
    private String startTime;

    /** 结束时间 */
    private String endTime;

    /** 商品 */
    private WaterOrderGoods waterOrderGoods;

    /** 商品 */
    @Excel(name = "商品")
    private List<WaterOrderGoods> waterOrderGoodsList;

    /** 触底请求参数 */
    private Integer pageNum;


    private String zfsj;

    private String tkbh;


    private String payTypeName;

    private String wctype;
}
