package com.qianhe.system.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.system.domain.WaterGoodsImg;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class WaterGoodsVo {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 订单商品类型 */
    private Integer orderGoodsType;

    /** 商品id */
    private Long goodsId;

    /** 标题 */
    @Excel(name = "标题")
    private String title;

    /** 类型 */
    @Excel(name = "类型")
    private Long goodsTypeId;

    /** 商品分类 */
    @Excel(name = "商品分类")
    private String goodsTypeName;

    /** 所属站点id */
    @Excel(name = "所属站点id")
    private String belongStationId;

    /** 所属站点名称 */
    @Excel(name = "所属站点名称")
    private String belongStationNames;

    /** 封面图 */
    @Excel(name = "封面图")
    private String coverImg;

    /** 详情图 */
    @Excel(name = "详情图")
    private String detailsImg;

    /** 价格 */
    @Excel(name = "价格")
    private BigDecimal price;

    /** 商品数量 */
    private Integer goodsNum;

    /** 销量 */
    @Excel(name = "销量")
    private String volume;

    /** 创建人 */
    private String  createUser;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 状态（1上架0下架） */
    @Excel(name = "状态", readConverterExp = "1=上架0下架")
    private Integer status;

    private String spjj;
    private String spe;
    private BigDecimal sjjg;

    private String speVal;

    /** 封面图集合 */
    private List<WaterGoodsImg> coverImgs;

    /** 详情图集合 */
    private List<WaterGoodsImg> detailsImgs;

    /** 商品规格id */
    private String goodsSpeId;

    /** 商品规格值id */
    private String goodsSpeValId;

    /** 商品规格详情 */
    private String goodsSpeVal;

    /** 商品关联规格集合 */
    private WaterGoodsSpeVo waterGoodsSpe;
}
