package com.qianhe.system.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.qianhe.common.annotation.Excel;
import com.qianhe.system.domain.WaterGoodsSpeVal;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class WaterGoodsSpeVo {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 商品规格主键id */
    private Long waterSpeId;

    /** 标题 */
    @Excel(name = "标题")
    private String speTitle;

    /** 商品id */
    @Excel(name = "商品id")
    private Long goodsId;

    /** 创建人 */
    private String  createUser;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 商品关联规格值集合 */
    private List<WaterGoodsSpeVal> waterGoodsSpeValList;

    /** 价格 */
    private BigDecimal price;
}
