package com.qianhe.system.utils;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class SsWxUserInfoUtils {

    @Value("${sswx.appId}")
    private String appId;

    @Value("${sswx.appSecret}")
    private String appSecret;

    @Autowired
    SsAccessTokenUtils accessTokenUtils;

    private static Logger log = LoggerFactory.getLogger(SsWxUserInfoUtils.class);

    /**
     * 获取openid喝session_key
     * @param code
     * @return
     */
    public Map<String, String> getWxLoginInfo(String code) {
        //微信登录凭证校验
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=" + appId + "&secret=" + appSecret + "&js_code=" + code + "&grant_type=authorization_code";
        //利用hutool发起get请求
        String result = HttpUtil.get(url);
        //使用 hutool 解析json
        JSONObject jsonObject = JSONUtil.parseObj(result);
        //获取会话密钥
        String session_key = (String) jsonObject.get("session_key");
        //获取用户在开放平台的唯一标识符
        String unionid = (String) jsonObject.get("unionid");
        //获取用户唯一标识
        String openid = (String) jsonObject.get("openid");
        Map<String,String> map = new HashMap<>();
        map.put("openid",openid);
        map.put("session_key",session_key);
        return map;
    }

    /**
     * 获取用户手机号
     */
    public String getWxUserPhone(String code){
        //获取accessToken
        String accessToken = accessTokenUtils.getToken();
        //获取phone
        String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber"
                + "?access_token=" + accessToken;
        String json = "{\"code\":\"" + code +  "\"}";
        String s = HttpClientUtil.doPostJson(url, json);
        JSONObject wxJson = JSONUtil.parseObj(s);
        //返回手机号信息
        JSONObject phone_info = JSONUtil.parseObj(wxJson.get("phone_info"));
        //用户绑定的手机号（国外手机号会有区号）
        String phoneNumber = (String) phone_info.get("phoneNumber");
        return phoneNumber;
    }


//    /**
//     * 解密用户手机号   (已废弃)
//     *
//     * @param encryptedData 包括敏感数据在内的完整用户信息的加密数据
//     * @param iv            加密算法的初始向量
//     */
//    public String getMobile(String encryptedData, String sesskey, String iv) {
//        String result = decryptData(encryptedData, sesskey, iv);
//        if (result == null) {
//            return null;
//        }
//        Map<String, String> map = new JSONObject(result).toBean(Map.class);
//        return map.get("phoneNumber");
//    }
//
//    /**
//     *  (已废弃)
//     * @param encryptedData
//     * @param sessionKey
//     * @param iv
//     * @return
//     */
//    public String decryptData(String encryptedData, String sessionKey, String iv) {
//        // 被加密的数据
//        byte[] dataByte = Base64Utils.decode(encryptedData.getBytes());
//        // 加密秘钥
//        byte[] keyByte = Base64Utils.decode(sessionKey.getBytes());
//        // 偏移量
//        byte[] ivByte = Base64Utils.decode(iv.getBytes());
//        try {
//            // 如果密钥不足16位，那么就补足. 这个if 中的内容很重要
//            int base = 16;
//            if (keyByte.length % base != 0) {
//                int groups = keyByte.length / base + (keyByte.length % base != 0 ? 1 : 0);
//                byte[] temp = new byte[groups * base];
//                Arrays.fill(temp, (byte) 0);
//                System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
//                keyByte = temp;
//            }
//            // 初始化
//            Security.addProvider(new BouncyCastleProvider());
//            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
//            SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
//            AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
//            parameters.init(new IvParameterSpec(ivByte));
//            // 初始化
//            cipher.init(Cipher.DECRYPT_MODE, spec, parameters);
//            byte[] resultByte = cipher.doFinal(dataByte);
//            if (null != resultByte && resultByte.length > 0) {
//                String result = new String(resultByte, "UTF-8");
//                return result;
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//        }
//        return null;
//    }
}
