package com.qianhe.system.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.qianhe.common.utils.uuid.UUID;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

@Component
public  class OSSUtil {
    @Value("${aliyun.endpoint}")
    private String endpoint;
    @Value("${aliyun.accessKeyId}")
    private String accessKeyId;
    @Value("${aliyun.accessKeySecret}")
    private String accessKeySecret;
    @Value("${aliyun.bucketName}")
    private String bucketName;
    @Value("${aliyun.urlPrefix}")
    private String urlPrefix;
    /**
     * 文件上传
     *
     * @return 返回文件的 阿里云url 路径
     */
    public  String upload(MultipartFile uploadFile,String fileName) {
        // 创建OSSClient实例。
        OSS ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        //定义子文件的格式
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = format.format(new Date());
        String fileUrl = urlPrefix+ (dateStr + "/" + fileName);
        // 上传到阿里云
        try {
            System.out.println("ossClient"+ossClient);
            ossClient.putObject(bucketName, fileUrl, new
                    ByteArrayInputStream(uploadFile.getBytes()));
        } catch (Exception e) {
            e.printStackTrace();

        }finally {
            if(ossClient!=null){
                ossClient.shutdown();
            }

        }
        //约定文件访问路径规则 https://BucketName.Endpoint/ObjectName
        StringBuilder stringBuilder = new StringBuilder("https://");
        stringBuilder
                .append(bucketName)
                .append(".")
                .append(endpoint)
                .append("/")
                .append(fileUrl);


        return stringBuilder.toString();
    }
}
