package com.qianhe.system.utils;

import com.ccb.CCBMisSdk;
import com.fasterxml.jackson.core.type.TypeReference;
import com.qianhe.system.config.Config;
import com.qianhe.system.enums.TransRequestEnum;
import com.qianhe.system.vo.MisApiHttpVo;
import com.qianhe.system.vo.MisApiResponseVo;
import org.springframework.beans.factory.annotation.Value;

public class MisApiUtil {


    public static void main(String[] args) {
//        String au011 = getAu011();
//        System.out.println(au011);
        String key="046031EFAEAAE920DD5781D054F2B7DB2073F6692013CEF131279C9304D20A854F0D2340C9D5DC5046A74C9554966B69B04CDE4D35A7473D6655C3FD8E60EF0F2754F6E9A598F398E92337B0EE85BC0314969C9F2261CF1A5531927555DE2AC0379C1D4C1ED33CD1A3928ECFD1890F6C94A7E86229C9ED0FD5E2201348C1272896";
        String privateKey="308193020100301306072a8648ce3d020106082a811ccf5501822d047930770201010420428e28dc5245f561f8139e4636efe5c9b24a919030c373fa8a436442e331d446a00a06082a811ccf5501822da144034200042093fae35d37b2624dcbd2d00883f81254e9ded5097351ce4736a1028ff8e84535678132ebae70d521a458675125c2bb5c261c676f126fc03dfafaab9e449d7f";
        String publicKey="3059301306072a8648ce3d020106082a811ccf5501822d034200042093fae35d37b2624dcbd2d00883f81254e9ded5097351ce4736a1028ff8e84535678132ebae70d521a458675125c2bb5c261c676f126fc03dfafaab9e449d7f";
//
        CCBMisSdk.CCBMisSdk_KeyDecrypt(key, privateKey);
        System.out.println(CCBMisSdk.CCBMisSdk_KeyDecrypt(key, privateKey));

//        KeyUtilsBean misBankKey = CCBMisSdkUtils.getKeyUtilsBean();


    }

    /**
     * 根据授权码获取密钥
     * @return
     */
    public static String getAu011(String authCode) {
        System.out.println("交易码："+ TransRequestEnum.AU011);
        //构建请求参数
        MisApiHttpVo misApiHttpVo = new MisApiHttpVo(TransRequestEnum.AU011,Config.merchantCode, Config.terminalId, Config.termSN);

        KeyUtilsBean misBankKey = CCBMisSdkUtils.getKeyUtilsBean();
        System.out.println("privateKey"+misBankKey.getPrivateKey());
        misApiHttpVo.setPublicKey(misBankKey.getPublicKey());

        misApiHttpVo.setAuthCode(authCode);

        //加密参数
        System.out.println("misApiHttpVo："+JsonUtil.toJsonString(misApiHttpVo));

        //发送请求
        String result = new RequestService().sendJsonPost(Config.url, null, JsonUtil.toJsonString(misApiHttpVo));
        System.out.println("result："+result);

        //json转对象
        MisApiResponseVo misApiResponse = JsonUtil.jsonStringToObject(result, new TypeReference<MisApiResponseVo>() {
        });
        System.out.println("misApiResponse"+misApiResponse);
        if("00".equals(misApiResponse.getRetCode())){
            //解密数据

            System.out.println(CCBMisSdk.CCBMisSdk_KeyDecrypt(misApiResponse.getKey(), misBankKey.getPrivateKey()));
            String key=CCBMisSdk.CCBMisSdk_KeyDecrypt(misApiResponse.getKey(), misBankKey.getPrivateKey());
            return key;
        }else{
            //请求失败
            System.out.println(misApiResponse.getRetErrMsg());
            return null;
        }

    }

    /**
     * 密钥更新
     * @return
     */

    public static String getAu012Key(String key) {
        System.out.println("交易码："+ TransRequestEnum.AU012);
        //构建请求参数
        MisApiHttpVo misApiHttpVo = new MisApiHttpVo(TransRequestEnum.AU012, Config.merchantCode, Config.terminalId, Config.termSN);
        KeyUtilsBean misBankKey = CCBMisSdkUtils.getKeyUtilsBean();
        misApiHttpVo.setPublicKey(misBankKey.getPublicKey());
        misApiHttpVo.sign(misBankKey.getPrivateKey(), key);
        //加密参数
        System.out.println("misApiHttpVo："+ JsonUtil.toJsonString(misApiHttpVo));

        //发送请求
        String result = new RequestService().sendJsonPost(Config.url, null, JsonUtil.toJsonString(misApiHttpVo));
        System.out.println("result："+result);

        //json转对象
        MisApiResponseVo misApiResponse = JsonUtil.jsonStringToObject(result, new TypeReference<MisApiResponseVo>() {
        });
        if("00".equals(misApiResponse.getRetCode())){
            //解密数据
            System.out.println(CCBMisSdk.CCBMisSdk_KeyDecrypt(misApiResponse.getKey(), misBankKey.getPrivateKey()));
            return CCBMisSdk.CCBMisSdk_KeyDecrypt(misApiResponse.getKey(), misBankKey.getPrivateKey());
        }else{
            //请求失败
            System.out.println(misApiResponse.getRetErrMsg());
        }
        return null;
    }

    /**
     * 密钥确认
     * @param key
     * @return
     */
    public static boolean confirmKey(String key) {
        System.out.println("交易码："+ TransRequestEnum.AU013);
        //构建请求参数
        MisApiHttpVo misApiHttpVo = new MisApiHttpVo(TransRequestEnum.AU013, Config.merchantCode, Config.terminalId, Config.termSN);
        KeyUtilsBean misBankKey = CCBMisSdkUtils.getKeyUtilsBean();
        misApiHttpVo.setPublicKey(misBankKey.getPublicKey());
        misApiHttpVo.sign(misBankKey.getPrivateKey(), key);
        //加密参数
        System.out.println("misApiHttpVo："+ JsonUtil.toJsonString(misApiHttpVo));

        //发送请求
        String result = new RequestService().sendJsonPost(Config.url, null, JsonUtil.toJsonString(misApiHttpVo));
        System.out.println("result："+result);

        //json转对象
        MisApiResponseVo misApiResponse = JsonUtil.jsonStringToObject(result, new TypeReference<MisApiResponseVo>() {
        });
        if("00".equals(misApiResponse.getRetCode())){
            //解密数据
            System.out.println(misApiResponse.getRetErrMsg());
            return true;
        }else{
            //请求失败
            System.out.println(misApiResponse.getRetErrMsg());
            return false;
        }
    }
}
