package com.qianhe.system.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author yc
 * @version 1.0
 * @className MD5
 * @date 2024/3/28 17:44
 * @description
 */
public class MD5 {
    /**
     * 对字符串进行32位MD5加密
     * @param str
     * @return
     */
    public static String EncodeByMD5(String str) {
        try {
            // 将字符串转换为UTF-8编码的字节数组
            byte[] inputBytes = str.getBytes("UTF-8");

            // 创建一个 MessageDigest 实例，指定使用 MD5 算法
            MessageDigest md = MessageDigest.getInstance("MD5");

            // 计算 MD5 哈希值
            byte[] hashBytes = md.digest(inputBytes);

            // 将字节数组转换为十六进制字符串
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }

            // 打印 MD5 哈希值
            System.out.println("MD5 哈希值：" + hexString.toString());
            return hexString.toString();
        } catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String fillMD5(String md5){
        //如果不够32位则回调自身补零，最后返回32位长度的签名
        return md5.length()==32?md5:fillMD5("0"+md5);
    }


    public static void main(String[] args) {
        String input = "MERCHANTID=105000182492747&POSID=078751081&BRANCHID=370000000&ORDERID=1734395575583854593&PAYMENT=0.01&CURCODE=01&TXCODE=530590&REMARK1=1&REMARK2=&TYPE=1&PUB=0d6c325f2c31bc1561ba1317020111&GATEWAY=0&CLIENTIP=127.0.0.1&REGINFO=ou5vA6wS-mxPBQfVszdl922jNKGY&PROINFO=%u5730%u70b9&REFERER=&TRADE_TYPE=MINIPRO&SUB_APPID=wxb9998f75c8e7b657&SUB_OPENID=ou5vA6wS-mxPBQfVszdl922jNKGY"; // 要加密的字符串

        try {
            // 将字符串转换为UTF-8编码的字节数组
            byte[] inputBytes = input.getBytes("UTF-8");

            // 创建一个 MessageDigest 实例，指定使用 MD5 算法
            MessageDigest md = MessageDigest.getInstance("MD5");

            // 计算 MD5 哈希值
            byte[] hashBytes = md.digest(inputBytes);

            // 将字节数组转换为十六进制字符串
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }

            // 打印 MD5 哈希值
            System.out.println("MD5 哈希值：" + hexString.toString());
        } catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}