package com.qianhe.system.task;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.system.domain.WaterOrder;
import com.qianhe.system.service.IWaterOrderService;
import com.qianhe.system.vo.WaterOrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component("waterTask")
public class WaterTask {

    @Autowired
    private IWaterOrderService waterOrderService;

    /**
     * 修改订单状态
     */
    public void updateOrderState(){
        //查询今天和昨天所有的订单
        List<WaterOrder> waterOrders = waterOrderService.selectOrderListByTime();
        //循环计算所有超过12小时的订单
        for (WaterOrder waterOrder : waterOrders) {
            //判断该订单是退款订单还是普通订单
            if (waterOrder.getOrderType() == 1){
                // 计算差值并转换为小时数
                long difference = waterOrder.getCreateTime().getTime() - DateUtils.getNowDate().getTime();
                long hours = difference / (60 * 60 * 1000);
                //判断该订单是否已超过二十四小时
                if (hours > 24){
                    //普通订单，修改订单状态为已完成
                    //判断送水工是否点击已送达
                    if (waterOrder.getCompleteState() == 1){
                        WaterOrderVo waterOrderVo = new WaterOrderVo();
                        waterOrderVo.setId(waterOrder.getId());
                        waterOrderVo.setOrderState(4);
                        waterOrderVo.setConfirmState(1);
                        waterOrderVo.setFinishTime(DateUtils.getNowDate());
                        waterOrderService.updateWaterOrder1(waterOrderVo);
                    }
                }
            }else {
                //退款订单
                // 计算差值并转换为小时数
                long difference = waterOrder.getCreateTime().getTime() - DateUtils.getNowDate().getTime();
                long hours = difference / (60 * 60 * 1000);
                //判断退款订单是否超过二十四小时
                if (hours > 24){
                    //退款订单，修改订单状态为已退款
                    //判断送水工是否点击已退款
                    if (waterOrder.getCompleteState() == 2){
                        WaterOrderVo waterOrderVo = new WaterOrderVo();
                        waterOrderVo.setId(waterOrder.getId());
                        waterOrderVo.setOrderState(6);
                        waterOrderVo.setConfirmState(2);
                        waterOrderVo.setFinishTime(DateUtils.getNowDate());
                        waterOrderService.updateWaterOrder1(waterOrderVo);
                    }
                }
            }
        }
    }
}
