package com.qianhe.system.service.impl.api;

import com.qianhe.common.core.domain.model.MpLoginUser;
import com.qianhe.common.core.domain.model.WxLoginBody;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.mapper.WaterUserMapper;
import com.qianhe.system.service.api.IWxLoginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxLoginServiceImpl implements IWxLoginService {

    @Autowired
    private WaterUserMapper waterUserMapper;

    @Override
    public MpLoginUser login(WxLoginBody wxLoginBody) {
        //根据用户openid查询用户是否存在
        WaterUser user = waterUserMapper.selectUserByOpenId(wxLoginBody.getOpenId(),"1");
        if (StringUtils.isNotNull(user)){
            //存在
            MpLoginUser loginUser = new MpLoginUser();
            loginUser.setOpenId(wxLoginBody.getOpenId());
            loginUser.setUserId(user.getId());
            loginUser.setNickName(user.getNickName());
            loginUser.setIsNewUser("0");
            return loginUser;
        }
        //不存在，新增用户
        WaterUser waterUser = new WaterUser();
        waterUser.setNickName("微信用户");
        waterUser.setUserType("1");
        waterUser.setOpenId(wxLoginBody.getOpenId());
        waterUser.setCreateTime(DateUtils.getNowDate());
        waterUser.setPhoneNum(Long.valueOf(wxLoginBody.getPhone()));
        waterUserMapper.insertWaterUser(waterUser);

        MpLoginUser loginUser = new MpLoginUser();
        loginUser.setOpenId(wxLoginBody.getOpenId());
        loginUser.setUserId(waterUser.getId());
        loginUser.setNickName("微信用户");
        loginUser.setIsNewUser("1");
        return loginUser;
    }

    @Override
    public MpLoginUser ssLogin(WxLoginBody wxLoginBody) {
        //根据用户openid查询用户是否存在
        WaterUser user = waterUserMapper.selectUserByOpenId(wxLoginBody.getOpenId(),"2");

        if (StringUtils.isNotNull(user)){
            //存在
            MpLoginUser loginUser = new MpLoginUser();
            loginUser.setOpenId(wxLoginBody.getOpenId());
            loginUser.setUserId(user.getId());
            loginUser.setNickName(user.getNickName());
            loginUser.setIsNewUser("0");
            loginUser.setPhone(Long.valueOf(wxLoginBody.getPhone()));
            return loginUser;
        }
        //不存在，新增用户
        WaterUser waterUser = new WaterUser();
        waterUser.setNickName("微信用户");
        waterUser.setUserType("2");
        waterUser.setOpenId(wxLoginBody.getOpenId());
        waterUser.setCreateTime(DateUtils.getNowDate());
        waterUser.setPhoneNum(Long.valueOf(wxLoginBody.getPhone()));
        waterUserMapper.insertWaterUser(waterUser);

        MpLoginUser loginUser = new MpLoginUser();
        loginUser.setOpenId(wxLoginBody.getOpenId());
        loginUser.setUserId(waterUser.getId());
        loginUser.setNickName("微信用户");
        loginUser.setIsNewUser("1");
        return loginUser;
    }
}
