package com.qianhe.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qianhe.common.core.domain.model.WxLoginBody;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.domain.WaterUserAddress;
import com.qianhe.system.mapper.WaterUserAddressMapper;
import com.qianhe.system.mapper.WaterUserMapper;
import com.qianhe.system.service.IWaterUserService;
import com.qianhe.system.vo.WaterUserVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 用户Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterUserServiceImpl extends ServiceImpl<WaterUserMapper,WaterUser> implements IWaterUserService
{
    @Autowired
    private WaterUserMapper waterUserMapper;
    @Autowired
    private WaterUserAddressMapper waterUserAddressMapper;

    /**
     * 查询用户
     *
     * @param id 用户主键
     * @return 用户
     */
    @Override
    public WaterUserVo selectWaterUserById(Long id)
    {
        //转vo
        WaterUser waterUser = waterUserMapper.selectWaterUserById(id);
        WaterUserVo waterUserVo = new WaterUserVo();
        BeanUtils.copyProperties(waterUser,waterUserVo);
        //查询用户地址信息
        WaterUserAddress waterUserAddress = new WaterUserAddress();
        waterUserAddress.setWaterUserId(id);
        List<WaterUserAddress> waterUserAddresses = waterUserAddressMapper.selectWaterUserAddressList(waterUserAddress);
        waterUserVo.setWaterUserAddressList(waterUserAddresses);
        return waterUserVo;
    }

    /**
     * 查询用户列表
     *
     * @param waterUser 用户
     * @return 用户
     */
    @Override
    public List<WaterUser> selectWaterUserList(WaterUser waterUser)
    {
        return waterUserMapper.selectWaterUserList(waterUser);
    }

    /**
     * 新增用户
     *
     * @param waterUser 用户
     * @return 结果
     */
    @Override
    public int insertWaterUser(WaterUser waterUser)
    {
        waterUser.setCreateTime(DateUtils.getNowDate());
        return waterUserMapper.insertWaterUser(waterUser);
    }

    /**
     * 修改用户
     *
     * @param waterUser 用户
     * @return 结果
     */
    @Override
    public int updateWaterUser(WaterUser waterUser)
    {
        return waterUserMapper.updateWaterUser(waterUser);
    }

    /**
     * 批量删除用户
     *
     * @param ids 需要删除的用户主键
     * @return 结果
     */
    @Override
    public int deleteWaterUserByIds(Long[] ids)
    {
        //删除用户地址信息
        waterUserMapper.deleteWaterUserAddressByIds(ids);
        return waterUserMapper.deleteWaterUserByIds(ids);
    }

    /**
     * 删除用户信息
     *
     * @param id 用户主键
     * @return 结果
     */
    @Override
    public int deleteWaterUserById(Long id)
    {
        return waterUserMapper.deleteWaterUserById(id);
    }

    /**
     * 根据openid查询用户
     * @param openId
     * @return
     */
    @Override
    public WaterUser selectUserByOpenId(String openId,String userType) {
        return waterUserMapper.selectUserByOpenId(openId,userType);
    }

    /**
     * 根据openid修改用户信息
     * @param waterUser
     * @return
     */
    @Override
    public int updateUserByOpenId(WaterUser waterUser) {
        return waterUserMapper.updateUserByOpenId(waterUser);
    }

    @Override
    public Map<String, Integer> getUserSl() {
        return waterUserMapper.getUserSl();
    }

    @Override
    public Boolean getSfjz(WaterUser waterUser) {
        WaterUser waterUser1 = waterUserMapper.selectUserByOpenId(waterUser.getOpenId(), "1");
        if(waterUser1==null){
            return false;
        }
        if(StringUtils.isNotNull(waterUser1.getSfjz())){
            if("是".equals(waterUser1.getSfjz())){
                return true;
            }else {
                return false;
            }
        }else {
            return false;
        }

    }
}
