package com.qianhe.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.domain.WaterUserAddress;
import com.qianhe.system.mapper.WaterUserAddressMapper;
import com.qianhe.system.service.IWaterUserAddressService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户地址Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterUserAddressServiceImpl extends ServiceImpl<WaterUserAddressMapper,WaterUserAddress> implements IWaterUserAddressService
{
    @Autowired
    private WaterUserAddressMapper waterUserAddressMapper;

    /**
     * 查询用户地址
     *
     * @param id 用户地址主键
     * @return 用户地址
     */
    @Override
    public WaterUserAddress selectWaterUserAddressById(Long id)
    {
        return waterUserAddressMapper.selectWaterUserAddressById(id);
    }

    /**
     * 查询用户地址列表
     *
     * @param waterUserAddress 用户地址
     * @return 用户地址
     */
    @Override
    public List<WaterUserAddress> selectWaterUserAddressList(WaterUserAddress waterUserAddress)
    {
        return waterUserAddressMapper.selectWaterUserAddressList(waterUserAddress);
    }

    /**
     * 新增用户地址
     *
     * @param waterUserAddress 用户地址
     * @return 结果
     */
    @Override
    public int insertWaterUserAddress(WaterUserAddress waterUserAddress)
    {
        //判断用户是否设置默认地址
        if (StringUtils.isNotEmpty(waterUserAddress.getIsDefault()) && waterUserAddress.getIsDefault().equals("1")) {
            //将该用户所有默认地址设备不默认
            waterUserAddressMapper.updateDefaultAddress(waterUserAddress.getWaterUserId());
        }
        return waterUserAddressMapper.insertWaterUserAddress(waterUserAddress);
    }

    /**
     * 修改用户地址
     *
     * @param waterUserAddress 用户地址
     * @return 结果
     */
    @Override
    public int updateWaterUserAddress(WaterUserAddress waterUserAddress)
    {
        //判断用户是否设置默认地址
        if (StringUtils.isNotEmpty(waterUserAddress.getIsDefault()) && waterUserAddress.getIsDefault().equals("1")) {
            //将该用户所有默认地址设备不默认
            waterUserAddressMapper.updateDefaultAddress(waterUserAddress.getWaterUserId());
        }
        try{
            waterUserAddressMapper.updateWaterUserAddress(waterUserAddress);
        }catch (Exception e){
            e.printStackTrace();
        }
        return  1;
    }

    /**
     * 批量删除用户地址
     *
     * @param ids 需要删除的用户地址主键
     * @return 结果
     */
    @Override
    public int deleteWaterUserAddressByIds(Long[] ids)
    {
        return waterUserAddressMapper.deleteWaterUserAddressByIds(ids);
    }

    /**
     * 删除用户地址信息
     *
     * @param id 用户地址主键
     * @return 结果
     */
    @Override
    public int deleteWaterUserAddressById(Long id)
    {
        return waterUserAddressMapper.deleteWaterUserAddressById(id);
    }

    /**
     * 获取用户默认地址
     * @return
     */
    @Override
    public WaterUserAddress getUserDefaultAddress(Long userId) {
        return waterUserAddressMapper.getUserDefaultAddress(userId);
    }

    /**
     * 修改用户默认地址
     * @param waterUserAddress
     * @return
     */
    @Override
    public int updateDefaultAddress(WaterUserAddress waterUserAddress) {
        //将该用户所有默认地址设备不默认
        waterUserAddressMapper.updateDefaultAddress(waterUserAddress.getWaterUserId());
        //设置用户默认地址
        return waterUserAddressMapper.updateWaterUserAddress(waterUserAddress);
    }
}
