package com.qianhe.system.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.system.domain.WaterText;
import com.qianhe.system.mapper.WaterTextMapper;
import com.qianhe.system.service.IWaterTextService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 通知公告文本Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterTextServiceImpl implements IWaterTextService
{
    @Autowired
    private WaterTextMapper waterTextMapper;

    /**
     * 查询通知公告文本
     *
     * @param id 通知公告文本主键
     * @return 通知公告文本
     */
    @Override
    public WaterText selectWaterTextById(Long id)
    {
        return waterTextMapper.selectWaterTextById(id);
    }

    /**
     * 查询通知公告文本列表
     *
     * @param waterText 通知公告文本
     * @return 通知公告文本
     */
    @Override
    public List<WaterText> selectWaterTextList(WaterText waterText)
    {
        return waterTextMapper.selectWaterTextList(waterText);
    }

    /**
     * 新增通知公告文本
     *
     * @param waterText 通知公告文本
     * @return 结果
     */
    @Override
    public int insertWaterText(WaterText waterText)
    {
        waterText.setCreateTime(DateUtils.getNowDate());
        return waterTextMapper.insertWaterText(waterText);
    }

    /**
     * 修改通知公告文本
     *
     * @param waterText 通知公告文本
     * @return 结果
     */
    @Override
    public int updateWaterText(WaterText waterText)
    {
        return waterTextMapper.updateWaterText(waterText);
    }

    /**
     * 批量删除通知公告文本
     *
     * @param ids 需要删除的通知公告文本主键
     * @return 结果
     */
    @Override
    public int deleteWaterTextByIds(Long[] ids)
    {
        return waterTextMapper.deleteWaterTextByIds(ids);
    }

    /**
     * 删除通知公告文本信息
     *
     * @param id 通知公告文本主键
     * @return 结果
     */
    @Override
    public int deleteWaterTextById(Long id)
    {
        return waterTextMapper.deleteWaterTextById(id);
    }
}
