package com.qianhe.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.system.domain.WaterStationUser;
import com.qianhe.system.mapper.WaterStationUserMapper;
import com.qianhe.system.service.IWaterStationUserService;
import com.qianhe.system.vo.WaterStationUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 站点用户Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterStationUserServiceImpl extends ServiceImpl<WaterStationUserMapper,WaterStationUser> implements IWaterStationUserService
{
    @Autowired
    private WaterStationUserMapper waterStationUserMapper;

    /**
     * 查询站点用户
     *
     * @param id 站点用户主键
     * @return 站点用户
     */
    @Override
    public WaterStationUser selectWaterStationUserById(Long id)
    {
        return waterStationUserMapper.selectWaterStationUserById(id);
    }

    /**
     * 查询站点用户列表
     *
     * @param waterStationUser 站点用户
     * @return 站点用户
     */
    @Override
    public List<WaterStationUserVo> selectWaterStationUserList(WaterStationUser waterStationUser)
    {
        return waterStationUserMapper.selectWaterStationUserList(waterStationUser);
    }

    /**
     * 新增站点用户
     *
     * @param waterStationUser 站点用户
     * @return 结果
     */
    @Override
    public int insertWaterStationUser(WaterStationUser waterStationUser)
    {
        waterStationUser.setCreateUser(SecurityUtils.getLoginUser().getUsername());
        waterStationUser.setCreateTime(DateUtils.getNowDate());
        return waterStationUserMapper.insertWaterStationUser(waterStationUser);
    }

    /**
     * 修改站点用户
     *
     * @param waterStationUser 站点用户
     * @return 结果
     */
    @Override
    public int updateWaterStationUser(WaterStationUser waterStationUser)
    {
        return waterStationUserMapper.updateWaterStationUser(waterStationUser);
    }

    /**
     * 批量删除站点用户
     *
     * @param ids 需要删除的站点用户主键
     * @return 结果
     */
    @Override
    public int deleteWaterStationUserByIds(Long[] ids)
    {
        return waterStationUserMapper.deleteWaterStationUserByIds(ids);
    }

    /**
     * 删除站点用户信息
     *
     * @param id 站点用户主键
     * @return 结果
     */
    @Override
    public int deleteWaterStationUserById(Long id)
    {
        return waterStationUserMapper.deleteWaterStationUserById(id);
    }

    /**
     * 根据手机号查询站点用户
     * @param phone 站点用户手机号
     * @return
     */
    @Override
    public WaterStationUserVo selectWaterStationUserByPhone(Long phone) {
        return waterStationUserMapper.selectWaterStationUserByPhone(phone);
    }
}
