package com.qianhe.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.system.mapper.WaterStationRegionMapper;
import com.qianhe.system.domain.WaterStationRegion;
import com.qianhe.system.service.IWaterStationRegionService;

/**
 * 站点区域范围Service业务层处理
 *
 * @author qianhe
 * @date 2024-04-15
 */
@Service
public class WaterStationRegionServiceImpl implements IWaterStationRegionService
{
    @Autowired
    private WaterStationRegionMapper waterStationRegionMapper;

    /**
     * 查询站点区域范围
     *
     * @param ID 站点区域范围主键
     * @return 站点区域范围
     */
    @Override
    public WaterStationRegion selectWaterStationRegionByID(Long ID)
    {
        return waterStationRegionMapper.selectWaterStationRegionByID(ID);
    }

    /**
     * 查询站点区域范围列表
     *
     * @param waterStationRegion 站点区域范围
     * @return 站点区域范围
     */
    @Override
    public List<WaterStationRegion> selectWaterStationRegionList(WaterStationRegion waterStationRegion)
    {
        return waterStationRegionMapper.selectWaterStationRegionList(waterStationRegion);
    }

    /**
     * 新增站点区域范围
     *
     * @param waterStationRegion 站点区域范围
     * @return 结果
     */
    @Override
    public int insertWaterStationRegion(WaterStationRegion waterStationRegion)
    {
        return waterStationRegionMapper.insertWaterStationRegion(waterStationRegion);
    }

    /**
     * 修改站点区域范围
     *
     * @param waterStationRegion 站点区域范围
     * @return 结果
     */
    @Override
    public int updateWaterStationRegion(WaterStationRegion waterStationRegion)
    {
        return waterStationRegionMapper.updateWaterStationRegion(waterStationRegion);
    }

    /**
     * 批量删除站点区域范围
     *
     * @param IDs 需要删除的站点区域范围主键
     * @return 结果
     */
    @Override
    public int deleteWaterStationRegionByIDs(Long[] IDs)
    {
        return waterStationRegionMapper.deleteWaterStationRegionByIDs(IDs);
    }

    /**
     * 删除站点区域范围信息
     *
     * @param ID 站点区域范围主键
     * @return 结果
     */
    @Override
    public int deleteWaterStationRegionByID(Long ID)
    {
        return waterStationRegionMapper.deleteWaterStationRegionByID(ID);
    }
}
