package com.qianhe.system.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.domain.WaterSpe;
import com.qianhe.system.domain.WaterSpeVal;
import com.qianhe.system.mapper.WaterSpeMapper;
import com.qianhe.system.service.IWaterSpeService;
import com.qianhe.system.vo.WaterSpeVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * 商品规格Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterSpeServiceImpl implements IWaterSpeService
{
    @Autowired
    private WaterSpeMapper waterSpeMapper;

    /**
     * 查询商品规格
     *
     * @param id 商品规格主键
     * @return 商品规格
     */
    @Override
    public WaterSpeVo selectWaterSpeById(Long id)
    {
        WaterSpe waterSpe = waterSpeMapper.selectWaterSpeById(id);
        //转vo
        WaterSpeVo waterSpeVo = new WaterSpeVo();
        BeanUtils.copyProperties(waterSpe,waterSpeVo);
        //根据商品规格主键id查找商品规格规格值
        WaterSpeVal waterSpeVal = new WaterSpeVal();
        waterSpeVal.setSpeId(id);
        List<WaterSpeVal> waterSpeVals = waterSpeMapper.selectWaterSpeValList(waterSpeVal);
        if (waterSpeVals.size() > 0){
            waterSpeVo.setWaterSpeValList(waterSpeVals);
        }
        return waterSpeVo;
    }

    /**
     * 查询商品规格列表
     *
     * @param waterSpe 商品规格
     * @return 商品规格
     */
    @Override
    public List<WaterSpe> selectWaterSpeList(WaterSpe waterSpe)
    {
        return waterSpeMapper.selectWaterSpeList(waterSpe);
    }

    /**
     * 新增商品规格
     *
     * @param waterSpeVo 商品规格
     * @return 结果
     */
    @Override
    public int insertWaterSpe(WaterSpeVo waterSpeVo)
    {
        waterSpeVo.setCreateUser(SecurityUtils.getLoginUser().getUsername());
        waterSpeVo.setCreateTime(DateUtils.getNowDate());
        int i = waterSpeMapper.insertWaterSpe(waterSpeVo);
        insertWaterSpeVal(waterSpeVo);
        return i;
    }

    private void insertWaterSpeVal(WaterSpeVo waterSpeVo) {
        //商品规格值列表
        List<WaterSpeVal> waterSpeValList = waterSpeVo.getWaterSpeValList();

        List<WaterSpeVal> waterSpeVals = new ArrayList<>();
        //商品规格主表id
        Long id = waterSpeVo.getId();
        if (StringUtils.isNotNull(waterSpeValList)){
            for (WaterSpeVal waterSpeVal : waterSpeValList) {
                String idd = UUID.randomUUID().toString();
                waterSpeVal.setId(idd);
                waterSpeVal.setSpeValId(idd);
                waterSpeVal.setSpeId(id);
                waterSpeVal.setSpeId(id);
                waterSpeVals.add(waterSpeVal);
            }
        }
        if (waterSpeVals.size() > 0){
            //批量新增
            waterSpeMapper.batchInsertWaterSpeVal(waterSpeVals);
//            waterSpeMapper.batchInsertWaterGoodsSpeVal(waterSpeVals);
        }
    }

    /**
     * 修改商品规格
     *
     * @param waterSpeVo 商品规格
     * @return 结果
     */
    @Override
    public int updateWaterSpe(WaterSpeVo waterSpeVo)
    {
        //删除商品规格关联的规格规格值
        waterSpeMapper.deleteWaterSpeValBySpeId(waterSpeVo.getId());
//        waterSpeMapper.deleteWaterGoodsSpeValBySpeId(waterSpeVo.getId());
        //新增规格规格值
        insertWaterSpeVal(waterSpeVo);
        return waterSpeMapper.updateWaterSpe(waterSpeVo);
    }

    /**
     * 批量删除商品规格
     *
     * @param ids 需要删除的商品规格主键
     * @return 结果
     */
    @Override
    public int deleteWaterSpeByIds(Long[] ids)
    {
        //批量删除商品规格关联的规格规格值
        waterSpeMapper.deleteWaterSpeValBySpeIds(ids);
        return waterSpeMapper.deleteWaterSpeByIds(ids);
    }

    /**
     * 删除商品规格信息
     *
     * @param id 商品规格主键
     * @return 结果
     */
    @Override
    public int deleteWaterSpeById(Long id)
    {
        waterSpeMapper.deleteWaterSpeValBySpeId(id);
        return waterSpeMapper.deleteWaterSpeById(id);
    }

    @Override
    public List<WaterSpeVal> selectWaterSpeValList(WaterSpeVal waterSpeVal) {
        return waterSpeMapper.selectWaterSpeValList(waterSpeVal);
    }
}
