package com.qianhe.system.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ccb.CCBMisSdk;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.exception.ServiceException;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.config.Config;
import com.qianhe.system.domain.*;
import com.qianhe.system.enums.TransRequestEnum;
import com.qianhe.system.mapper.*;
import com.qianhe.system.service.IWaterOrderService;
import com.qianhe.system.utils.JsonUtil;
import com.qianhe.system.utils.PositionUtil;
import com.qianhe.system.utils.RequestService;
import com.qianhe.system.vo.*;
import io.swagger.models.auth.In;
import org.gavaghan.geodesy.Ellipsoid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 订单Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterOrderServiceImpl implements IWaterOrderService
{
    @Autowired
    private WaterOrderMapper waterOrderMapper;
    @Autowired
    private WaterOrderGoodsMapper waterOrderGoodsMapper;
    @Autowired
    private WaterGoodsMapper waterGoodsMapper;
    @Autowired
    private WaterGoodsImgMapper waterGoodsImgMapper;
    @Autowired
    private WaterGoodsCartMapper waterGoodsCartMapper;
    @Autowired
    private WaterUserAddressMapper waterUserAddressMapper;
    @Autowired
    private WaterStationMapper waterStationMapper;
    @Autowired
    private WaterStationUserMapper waterStationUserMapper;

    /**
     * 查询订单
     *
     * @param id 订单主键
     * @return 订单
     */
    @Override
    public WaterOrderVo selectWaterOrderById(Long id)
    {
        WaterOrder waterOrder = waterOrderMapper.selectWaterOrderById(id);
        //转vo
        WaterOrderVo waterOrderVo = new WaterOrderVo();
        BeanUtils.copyProperties(waterOrder,waterOrderVo);
        //查询该订单商品
        WaterOrderGoods waterOrderGoods = new WaterOrderGoods();
        waterOrderGoods.setOrderId(id);
        List<WaterOrderGoods> waterOrderGoodsList = waterOrderGoodsMapper.selectWaterOrderGoodsList(waterOrderGoods);
        //查询商品图片信息
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgMapper.selectWaterGoodsImgList(new WaterGoodsImg());
        //订单商品集合
        List<WaterOrderGoods> waterOrderGoodsList1 = new ArrayList<>();
        if (waterOrderGoodsList.size() > 0){
            for (WaterOrderGoods waterOrderGood : waterOrderGoodsList) {
                //封面图集合
                List<WaterGoodsImg> coverImgs = new ArrayList<>();
                //详情图集合
                List<WaterGoodsImg> detailsImgs = new ArrayList<>();
                for (WaterGoodsImg waterGoodsImg : waterGoodsImgs) {
                    if (waterOrderGood.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 1){
                        coverImgs.add(waterGoodsImg);
                    }else if (waterOrderGood.getGoodsId().equals(waterGoodsImg.getGoodsId()) && waterGoodsImg.getImgType() == 2){
                        detailsImgs.add(waterGoodsImg);
                    }
                }
                if (coverImgs.size() > 0){
                    waterOrderGood.setCoverImgs(coverImgs);
                }
                if (detailsImgs.size() > 0){
                    waterOrderGood.setDetailsImgs(detailsImgs);
                }
                waterOrderGoodsList1.add(waterOrderGood);
            }
        }
        waterOrderVo.setWaterOrderGoodsList(waterOrderGoodsList1);
        return waterOrderVo;
    }

    /**
     * 查询订单列表
     *
     * @param waterOrderVo 订单
     * @return 订单
     */
    @Override
    public List<WaterOrder> selectWaterOrderList(WaterOrderVo waterOrderVo)
    {
        return waterOrderMapper.selectWaterOrderList(waterOrderVo);
    }

    /**
     * 新增订单
     *
     * @param waterOrderVo 订单
     * @return 结果
     */
    @Override
    @Transactional
    public String insertWaterOrder(WaterOrderVo waterOrderVo)
    {
        //判断用户下单是否有地址
        /*if (StringUtils.isNull(waterOrderVo.getUserAddressId())){
            throw new ServiceException("未选择地址！");
        }*/

        //判断用户地址是否在配送范围之内
        //前端已做下单控制，此处不用再做处理
        /*List<WaterStationVo> stations = getStation(waterOrderVo);
        if (stations.size() <= 0){
            return -1;
        }*/
       /* WaterStationVo station = stations.get(0);
        waterOrderVo.setStationId(station.getId());
        waterOrderVo.setStationName(station.getStationName());
        waterOrderVo.setStationPhone(station.getPhoneNum());
        waterOrderVo.setStationProvince(station.getProvince());
        waterOrderVo.setStationCity(station.getCity());
        waterOrderVo.setStationArea(station.getArea());
        waterOrderVo.setStationAddress(station.getStationAddress());*/
        waterOrderVo.setCreateUser(waterOrderVo.getUserId().toString());
        waterOrderVo.setCreateTime(DateUtils.getNowDate());
        String ddh = getOrerNum();
        waterOrderVo.setOrderNum(ddh);

        //判断支付方式是否为银行支付
        if(waterOrderVo.getPayType() == 1 ){
            //银行支付，修改订单状态为待付款
            waterOrderVo.setOrderState(1);
            waterOrderVo.setPayState(0);
            waterOrderVo.setOrderType(1);

        }else {
            //水票支付,修改订单状态为待接单
            waterOrderVo.setOrderState(2);
            waterOrderVo.setPayState(1);
            waterOrderVo.setOrderType(1);

        }
        int i = waterOrderMapper.insertWaterOrder(waterOrderVo);
        //新增订单商品
        insertWaterOrderGoods(waterOrderVo);
        //判断支付方式是否为水票支付
        if(waterOrderVo.getPayType() != 1 ){
            gzhSend(waterOrderVo);
        }
        return ddh;
    }

    /**
     * 获取与用户收货地址最近的站点信息
     */
    public List<WaterStationVo> getStation(WaterOrderVo waterOrderVo){
        //查询用户地址详细信息
        WaterUserAddress waterUserAddress = waterUserAddressMapper.selectWaterUserAddressById(waterOrderVo.getUserAddressId());
        //查询所有站点信息
        List<WaterStation> waterStationList = waterStationMapper.selectWaterStationList(new WaterStation());
        //获取距离用户收货地址最近的站点
        List<WaterStationVo> waterStationVoList = new ArrayList<>();
        for (WaterStation waterStation : waterStationList) {
            //计算距离
            double distance = PositionUtil.getDistance(waterUserAddress.getLon(), waterUserAddress.getLat(), waterStation.getStationLonTen(), waterStation.getStationLatTen(), Ellipsoid.WGS84);
            //换算成千米
            double distance1 = distance / 1000;
            if (distance1 <= 5){
                WaterStationVo waterStationVo = new WaterStationVo();
                BeanUtils.copyProperties(waterStation,waterStationVo);
                waterStationVo.setDistance(distance1);
                waterStationVoList.add(waterStationVo);
            }
        }
        //根据距离升序排序
        List<WaterStationVo> collect = waterStationVoList.stream().sorted(Comparator.comparing(WaterStationVo::getDistance)).collect(Collectors.toList());
        return collect;
    }

    /**
     * 生成订单编号
     * @return
     */
    public String getOrerNum(){
        String orderNum = "";
        //获取当前年月日
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(DateUtils.getNowDate());
        Long rqbh = Long.parseLong(today + "0001");
        while (true){
            WaterOrder waterOrder = new WaterOrder();
            waterOrder.setOrderNum(rqbh.toString());
            WaterOrder waterOrder1 = waterOrderMapper.selectWaterOrderNumByOrderNum(rqbh.toString());
            if (StringUtils.isNotNull(waterOrder1)){
                rqbh ++;
            }else {
                break;
            }
        }
        //生成随机四位英文字母
        Random random = new Random();
        String randomletters = "";
        for (int i = 0; i < 4; i++) {
            int index = random.nextInt(26);
            char letter = (char) ('A' + index);
            randomletters += letter;
        }
        orderNum = rqbh + randomletters;
        return orderNum;
    }

    private void insertWaterOrderGoods(WaterOrderVo waterOrderVo) {
        List<WaterOrderGoods> waterOrderGoodsList = waterOrderVo.getWaterOrderGoodsList();
        //商品订单主键id
        Long id = waterOrderVo.getId();
        //商品订单编号
        String orderNum = waterOrderVo.getOrderNum();
        if (StringUtils.isNotNull(waterOrderGoodsList)){
            for (WaterOrderGoods waterOrderGoods : waterOrderGoodsList) {
                //判断是否从购物车下单
                if (waterOrderVo.getOrderGoodsType() == 2){
                    //从购物车下单之后，对应商品将从购物车中清除
                    //根据商品信息查询购物车商品信息
                    WaterGoodsCart waterGoodsCart = new WaterGoodsCart();
                    waterGoodsCart.setUserId(waterOrderVo.getUserId());
                    waterGoodsCart.setId(waterOrderGoods.getGoodsId());
                    waterGoodsCart.setGoodsSpeVal(waterOrderGoods.getGoodsSpe());
                    List<WaterGoodsCart> list = waterGoodsCartMapper.selectWaterGoodsCartList(waterGoodsCart);
                    WaterGoodsCart waterGoodsCart1 = list.get(0);
                    //删除购物车商品
                    waterGoodsCartMapper.deleteWaterGoodsCartById(waterGoodsCart1.getId());
                }
                //根据商品id查询商品信息
                WaterGoods waterGoods = waterGoodsMapper.selectWaterGoodsById1(waterOrderGoods.getGoodsId());
                //判断商品是否下架
                if (waterGoods.getStatus() == 0) {
                    throw new ServiceException("该商品已下架，请您重新选择商品！");
                }
                waterOrderGoods.setOrderId(id);
                waterOrderGoods.setOrderNum(orderNum);
                waterOrderGoods.setGoodsTypeId(waterGoods.getGoodsTypeId());
                waterOrderGoods.setGoodsTitle(waterGoods.getTitle());
                waterOrderGoods.setCreateUser(waterOrderVo.getUserId().toString());
                waterOrderGoods.setCreateTime(DateUtils.getNowDate());
            }
            //批量新增订单商品
            waterOrderMapper.batchInsertWaterOrderGoods(waterOrderGoodsList);
        }
    }

    /**
     * 修改订单
     *
     * @param waterOrderVo 订单
     * @return 结果
     */
    @Override
    @Transactional
    public int updateWaterOrder(WaterOrderVo waterOrderVo)
    {
        //删除订单商品
        waterOrderMapper.deleteWaterOrderGoodsByOrderId(waterOrderVo.getId());
        //新增订单商品
        insertWaterOrderGoods(waterOrderVo);
        return waterOrderMapper.updateWaterOrder(waterOrderVo);
    }

    /**
     * 修改订单
     * @param waterOrderVo 订单
     * @return
     */
    @Override
    public int updateWaterOrder1(WaterOrderVo waterOrderVo) {
        return waterOrderMapper.updateWaterOrder(waterOrderVo);
    }

    /**
     * 批量删除订单
     *
     * @param ids 需要删除的订单主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteWaterOrderByIds(Long[] ids)
    {
        //批量删除订单商品
        waterOrderMapper.deleteWaterOrderGoodsByOrderIds(ids);
        return waterOrderMapper.deleteWaterOrderByIds(ids);
    }

    /**
     * 删除订单信息
     *
     * @param id 订单主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteWaterOrderById(Long id)
    {
        return waterOrderMapper.deleteWaterOrderById(id);
    }

    /**
     * 修改订单状态
     * @param waterOrderVo
     * @return
     */
    @Override
    @Transactional
    public int updateOrderState(WaterOrderVo waterOrderVo) {
        WaterOrder waterOrder = waterOrderMapper.selectWaterOrderById(waterOrderVo.getId());
        boolean flag=false;
        //接单时需再次查看该订单是否已经被用户所取消
        if (waterOrderVo.getOrderState() == 3){
            if (waterOrder.getOrderState() == 5){
                throw new ServiceException("该订单已被用户取消！");
            }
        }
        int i=0;
        //判断是否需要退款
        //传过来订单状态为取消
        if (waterOrderVo.getOrderState() == 5){
            //判断该订单是否已经支付，支付后取消，需要退款，将该订单改为退款订单
            //判断该订单支付方式是否为水票支付，水票支付不涉及退款
            if (waterOrder.getPayType() == 2 || waterOrder.getPayType() == 3){
                //为水票支付，该订单状态改为已取消
                waterOrderVo.setOrderState(5);

            }else {
                //银行支付，涉及线上退款
                if (waterOrder.getOrderState() == 2){
                    Date xdsj = waterOrder.getXdsj();
                    Date nowDate = DateUtils.getNowDate();

                    Calendar time1 = Calendar.getInstance();
                    Calendar time2 = Calendar.getInstance();
                    time1.setTime(xdsj);
                    time1.set(Calendar.HOUR_OF_DAY, 0);
                    time1.set(Calendar.MINUTE, 0);
                    time1.set(Calendar.SECOND, 0);
                    time1.set(Calendar.MILLISECOND, 0);
                    time2.setTime(nowDate);
                    time2.set(Calendar.HOUR_OF_DAY, 0);
                    time2.set(Calendar.MINUTE, 0);
                    time2.set(Calendar.SECOND, 0);
                    time2.set(Calendar.MILLISECOND, 0);
                    if(time1.equals(time2)){
                        //相等说明下单时间的晚上0点
                        //TODO 执行退款操作\
                        //先生成退款单号
                        String tkbh = getTkNum();
                        waterOrderVo.setTkbh(tkbh);
                        waterOrder.setTkbh(tkbh);
                        //执行退款操作
                        i = ccbRefund(waterOrder);
                        if(i==4){
                            return i;
                        }
                        //不相等说明下单时间的晚上0点
                        waterOrderVo.setOrderState(6);//已退款
                    }else {
                        flag=true;
                      //不相等说明下单时间的晚上0点
                        waterOrderVo.setOrderState(7);//线下处理
                    }
//                    waterOrder
                    //订单类型改为退款订单
                    waterOrderVo.setOrderType(2);
                    //此时取消原因为退款原因
                    waterOrderVo.setReturnOrderResult(waterOrderVo.getCancelResult());
                }
            }
        }

        i = waterOrderMapper.updateWaterOrder(waterOrderVo);
        if(flag){
         i=3;
        }
        return i;
    }

    /**
     * 生成退款编号
     * @return
     */
    public String getTkNum(){
        String orderNum = "";
        //获取当前年月日
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(DateUtils.getNowDate());
        Long rqbh = Long.parseLong(today + "0001");
        while (true){
            WaterOrder waterOrder = new WaterOrder();
            waterOrder.setOrderNum(rqbh.toString());
            WaterOrder waterOrder1 = waterOrderMapper.selectWaterOrderNumByOrderNum(rqbh.toString());
            if (StringUtils.isNotNull(waterOrder1)){
                rqbh ++;
            }else {
                break;
            }
        }
        //生成随机四位英文字母
        Random random = new Random();
        String randomletters = "";
        for (int i = 0; i < 4; i++) {
            int index = random.nextInt(26);
            char letter = (char) ('A' + index);
            randomletters += letter;
        }
        orderNum = "TK-"+rqbh + randomletters;
        return orderNum;
    }

    @Autowired
    private CcbKeyMapper ccbKeyMapper;

    public int ccbRefund(WaterOrder waterOrder){

        CcbKey ccbKey=new CcbKey();
        ccbKey.setSfgq("1");
        //第一次根据授权码下载密钥
        CcbKey ccbKey1 = ccbKeyMapper.selectCcbKeyList(ccbKey).stream().findFirst().orElse(null);
        String key = "";
        if(ccbKey1!=null){
            key=ccbKey1.getCcbkey();
        }
        //密钥更新
//        String key = MisApiUtil.getAu012Key();//密钥更新
//        MisApiUtil.confirmKey(key);;//密钥确认 确认后才能使用
//        System.out.println("key:"+key);

        if(StringUtils.isEmpty(key)){
            return 4;
        }
        System.out.println("key======"+key);
        String mchtNo=Config.merchantCode;//建行15位商户编号（固定）
        String termNo=Config.terminalId;//建行8位终端编号（固定）
        //参数
        String address=Config.address;//地址
        String gps=Config.gps;//GPS地理位置信息
        String amt=String.format("%.2f", waterOrder.getGoodsVal().setScale(2, BigDecimal.ROUND_DOWN).doubleValue());//退款金额
        String orderNo=waterOrder.getOrderNum();//订单号
        String numberId=waterOrder.getTkbh();//退款订单号
        //参数加密
        MisApiHttpVo misApiHttpVo = new MisApiHttpVo(TransRequestEnum.RF001, mchtNo, termNo,"1.2.0");
        TransRequest transResult = new TransRequest(address,null);
        TransData transData = new TransData();
        transData.setAmt(amt);
        transData.setOrderNo(orderNo);
        transData.setNumberId(numberId);
        transResult.setTransData(transData);
        System.out.println("transResult："+ JsonUtil.toJsonString(transResult));

        //加密参数
        misApiHttpVo.encodeData(JsonUtil.toJsonString(transResult), key);

        System.out.println("misApiHttpVo："+JsonUtil.toJsonString(misApiHttpVo));

        //发送请求
        String result = new RequestService().sendJsonPost(Config.url, null, JsonUtil.toJsonString(misApiHttpVo));
        System.out.println("result："+result);
        //json转对象
        MisApiResponseVo misApiResponse = JsonUtil.jsonStringToObject(result, new TypeReference<MisApiResponseVo>() {
        });
        if("00".equals(misApiResponse.getRetCode())){
            //解密数据
            String transResultStr = CCBMisSdk.CCBMisSdk_DataDecrypt(misApiResponse.getData(), key);
            System.out.println(transResultStr);
            return 5;
        }else{
            //请求失败
            System.out.println(misApiResponse.getRetErrMsg());
            return 4;
        }
    }
    /**
     * 统计站点订单数量
     * @param stationId
     * @return
     */
    @Override
    public Map<String, Integer> getOrderNumByStation(Long stationId) {
        WaterOrderVo waterOrderVo = new WaterOrderVo();
        waterOrderVo.setStationId(stationId);
        waterOrderVo.setCreateTime(DateUtils.getNowDate());
        Map<String, Integer> orderNumByStation1 = waterOrderMapper.getOrderNumByStation1(waterOrderVo);
        return orderNumByStation1;
    }

    /**
     * 根据站点查询订单信息
     * @param waterOrderVo 订单
     * @return
     */
    @Override
    public List<WaterOrderVo> getWaterOrderListByStationId(WaterOrderVo waterOrderVo) {
        return waterOrderMapper.getWaterOrderListByStationId(waterOrderVo);
    }

    /**
     * 修改订单完成状态（送水端）
     * @param waterOrderVo
     * @return
     */
    @Override
    public int updateCompleteState(WaterOrderVo waterOrderVo) {
        //设置送达时间
        waterOrderVo.setDelieverOver(DateUtils.getNowDate());
        //判断送水工是否点击已完成
        if (waterOrderVo.getCompleteState() == 1){
            waterOrderVo.setOrderState(4);
            waterOrderVo.setConfirmState(1);
            waterOrderVo.setTakeTime(DateUtils.getNowDate());
            waterOrderVo.setFinishTime(DateUtils.getNowDate());
            waterOrderVo.setWctype("送水工");
        }else {
            waterOrderVo.setOrderState(6);
            waterOrderVo.setConfirmState(2);
            waterOrderVo.setFinishTime(DateUtils.getNowDate());
            waterOrderVo.setWctype("送水工");
        }
        return waterOrderMapper.updateWaterOrder(waterOrderVo);
    }

    /**
     * 修改订单确认状态（订水端）
     * @param waterOrderVo
     * @return
     */
    @Override
    public int updateConfirmState(WaterOrderVo waterOrderVo) {
        int i = 0;
        //判断用户是否点击确认收货或确认收款
        if (waterOrderVo.getConfirmState() == 1){
            waterOrderVo.setOrderState(4);
            waterOrderVo.setCompleteState(1);
            waterOrderVo.setTakeTime(DateUtils.getNowDate());
            waterOrderVo.setFinishTime(DateUtils.getNowDate());
            waterOrderVo.setWctype("用户");
            i += waterOrderMapper.updateWaterOrder(waterOrderVo);
        }else if (waterOrderVo.getConfirmState() == 2){
            waterOrderVo.setOrderState(6);
            waterOrderVo.setCompleteState(2);
            waterOrderVo.setFinishTime(DateUtils.getNowDate());
            waterOrderVo.setWctype("用户");
            i += waterOrderMapper.updateWaterOrder(waterOrderVo);
        }
        return i;
    }

    /**
     * 根据用户查询订单数量
     * @param userId
     * @return
     */
    @Override
    public Map<String, Integer> getOrderNumByUser(Long userId) {
        Map<String, Integer> map = new HashMap<>();
        WaterOrderVo waterOrderVo = new WaterOrderVo();
        waterOrderVo.setUserId(userId);
        //待付款数量
        waterOrderVo.setOrderState(1);
        Map<String, Integer> dfk = waterOrderMapper.getOrderNumByUser(waterOrderVo);
        map.put("dfk",dfk.get("orderNum"));
        //待接单数量
        waterOrderVo.setOrderState(2);
        Map<String, Integer> djd = waterOrderMapper.getOrderNumByUser(waterOrderVo);
        map.put("djd",djd.get("orderNum"));
        //进行中数量
        waterOrderVo.setOrderState(3);
        Map<String, Integer> jxz = waterOrderMapper.getOrderNumByUser(waterOrderVo);
        map.put("jxz",jxz.get("orderNum"));
        //已完成数量
        waterOrderVo.setOrderState(4);
        Map<String, Integer> ywc = waterOrderMapper.getOrderNumByUser(waterOrderVo);
        map.put("ywc",ywc.get("orderNum"));
        return map;
    }

    /**
     * 查询今天和昨天的所有订单
     * @return
     */
    @Override
    public List<WaterOrder> selectOrderListByTime() {
        return waterOrderMapper.selectOrderListByTime();
    }

    /**
     * PC端首页统计
     * @return
     */
    @Override
    public Map<String, Integer> countOrderNum() {
       /* //获取当前年份
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getNowDate());
        int year = calendar.get(Calendar.YEAR);
        //统计普通订单
        List<Map<String, Integer>> pt = waterOrderMapper.countOrderNumByPt(year);
        //统计退款订单
        List<Map<String, Integer>> tk = waterOrderMapper.countOrderNumByTk(year);
        //返回列表
        List<Map<String,Integer>> tjList = new ArrayList<>();
        for (Map<String, Integer> map : pt) {
            for (Map<String, Integer> map1 : tk) {
                if (map.get("month").equals(map1.get("month"))){
                    Map<String,Integer> tj = new HashMap<>();
                    tj.put("month",map.get("month"));
                    tj.put("pt",map.get("count"));
                    tj.put("tk",map1.get("count"));
                    tjList.add(tj);
                }
            }
        }*/

        WaterOrderVo orderVo = new WaterOrderVo();
        orderVo.setCreateTime(DateUtils.getNowDate());
        return waterOrderMapper.getOrderNumByStation2(orderVo);
    }

    /**
     * 新增退款订单
     * @param waterOrderVo
     * @return
     */
    @Override
    public int addReturnOrder(WaterOrderVo waterOrderVo) {
        waterOrderVo.setCreateUser(waterOrderVo.getUserId().toString());
        waterOrderVo.setCreateTime(DateUtils.getNowDate());
        waterOrderVo.setOrderNum(getOrerNum());
        waterOrderVo.setOrderState(3);
        waterOrderVo.setOrderType(2);
        return waterOrderMapper.insertWaterOrder(waterOrderVo);
    }

    /**
     * 修改待付款订单状态(订水端)
     * @param waterOrderVo
     * @return
     */
    @Override
    public int updateOrderPayType(WaterOrderVo waterOrderVo) {
        //判断是否为水票支付,为水票支付,则订单直接变为待接单
        if (waterOrderVo.getPayType() == 2 || waterOrderVo.getPayType() == 3){
            waterOrderVo.setOrderState(2);
            waterOrderVo.setPayState(1);
        }
        return waterOrderMapper.updateWaterOrder(waterOrderVo);
    }
    @Value("${wxgzh.appId}")
    private String appId;

    @Value("${wxgzh.appSecret}")
    private String appSecret;
    @Value("${wxgzh.access-token-uri}")
    private String accessTokenUri;
    @Value("${wxgzh.template_id}")
    private String templateId;

    //根据appId、appSecret获取access_token
    public String getAccessToken() {
        String url = accessTokenUri;
        // 利用hutool的http工具类请求获取access_token
//        String result = HttpUtil.get(url);
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("grant_type","client_credential");
        paramMap.put("appid","wxb1da01db0d0feb95");
        paramMap.put("secret","5e7479823d02130a95ee8d868db515b2");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(paramMap);
        System.out.println( "url"+url);
        System.out.println( "参数"+json);
        String result = HttpRequest.post(url).body(json).execute().body();
        JSONObject jsonObject = JSONUtil.parseObj(result);
        return jsonObject.getStr("access_token");
    }
    @Override
    public AjaxResult gzhSend(WaterOrderVo vo) {
        //订单编号
        String orderNum = vo.getOrderNum();
        //站点id
//        Long stationId = vo.getStationId();
        //查询订单
        WaterOrder waterOrder = waterOrderMapper.selectWaterOrderNumByOrderNum(orderNum);
        if(waterOrder!=null){
            WaterOrderGoods goods=new WaterOrderGoods();
            goods.setOrderId(waterOrder.getId());
            List<WaterOrderGoods> waterOrderGoods = waterOrderGoodsMapper.selectWaterOrderGoodsList(goods);
            String spmc="";
            //查询商品名称
            if(waterOrderGoods.size()>0){
                spmc = String.join(",", waterOrderGoods.stream().map(WaterOrderGoods::getGoodsTitle).collect(Collectors.toList()));
            }
            //支付方式1银行2水票
            Integer payType = waterOrder.getPayType();
            //查询
            WaterStationUser user =new WaterStationUser();
            user.setStationId(waterOrder.getStationId());
            List<WaterStationUserVo> waterStationUsers = waterStationUserMapper.selectWaterStationUserList(user);
            if(waterStationUsers.size()>0){
                DecimalFormat df1 = new DecimalFormat("#.00");
                for(WaterStationUserVo item:waterStationUsers){
                    //获取标签标签tagid
                    String accessToken= getAccessToken();
                    //发送模板消息
                    JSONObject body=new JSONObject();
                    String requestUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token="  + accessToken;
                    body.set("touser",item.getOpenId());
                    body.set("template_id",templateId);
                    JSONObject json=new JSONObject();
                    json.set("thing27",new JSONObject().set("value",spmc));//商品名称
                    System.out.println(waterOrder.getGoodsVal());
                    String format = "";
                    if(payType==1){
                        format=String.format("%.2f", waterOrder.getGoodsVal().setScale(2, BigDecimal.ROUND_DOWN).doubleValue());
                    }else if(payType==2){
                        format="水票";
                    }else if(payType==3){
                        format="记账";
                    }
                    json.set("amount24",new JSONObject().set("value", format));//金额
                    json.set("time4",new JSONObject().set("value",DateUtils.parseDateToStr("yyyy-MM-dd hh:mm:ss",waterOrder.getCreateTime())));//下单时间
                    json.set("phone_number8",new JSONObject().set("value", waterOrder.getUserPhone()));//用户手机号
                    body.set("data",json);
                    String resp = HttpUtil.post(requestUrl,body.toString());
                    JSONObject result = JSONUtil.parseObj(resp);
                    System.out.println("发送消息:" + resp);
                    System.out.println("发送消息:" + result);
                }
            }
            return  AjaxResult.error("发送成功");
        }else {
            return  AjaxResult.error("发送失败");
        }


    }
}
