package com.qianhe.system.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.system.domain.WaterOrderLog;
import com.qianhe.system.mapper.WaterOrderLogMapper;
import com.qianhe.system.service.IWaterOrderLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 订单日志Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterOrderLogServiceImpl implements IWaterOrderLogService
{
    @Autowired
    private WaterOrderLogMapper waterOrderLogMapper;

    /**
     * 查询订单日志
     *
     * @param id 订单日志主键
     * @return 订单日志
     */
    @Override
    public WaterOrderLog selectWaterOrderLogById(Long id)
    {
        return waterOrderLogMapper.selectWaterOrderLogById(id);
    }

    /**
     * 查询订单日志列表
     *
     * @param waterOrderLog 订单日志
     * @return 订单日志
     */
    @Override
    public List<WaterOrderLog> selectWaterOrderLogList(WaterOrderLog waterOrderLog)
    {
        return waterOrderLogMapper.selectWaterOrderLogList(waterOrderLog);
    }

    /**
     * 新增订单日志
     *
     * @param waterOrderLog 订单日志
     * @return 结果
     */
    @Override
    public int insertWaterOrderLog(WaterOrderLog waterOrderLog)
    {
        waterOrderLog.setCreateTime(DateUtils.getNowDate());
        return waterOrderLogMapper.insertWaterOrderLog(waterOrderLog);
    }

    /**
     * 修改订单日志
     *
     * @param waterOrderLog 订单日志
     * @return 结果
     */
    @Override
    public int updateWaterOrderLog(WaterOrderLog waterOrderLog)
    {
        return waterOrderLogMapper.updateWaterOrderLog(waterOrderLog);
    }

    /**
     * 批量删除订单日志
     *
     * @param ids 需要删除的订单日志主键
     * @return 结果
     */
    @Override
    public int deleteWaterOrderLogByIds(Long[] ids)
    {
        return waterOrderLogMapper.deleteWaterOrderLogByIds(ids);
    }

    /**
     * 删除订单日志信息
     *
     * @param id 订单日志主键
     * @return 结果
     */
    @Override
    public int deleteWaterOrderLogById(Long id)
    {
        return waterOrderLogMapper.deleteWaterOrderLogById(id);
    }
}
