package com.qianhe.system.service.impl;

import com.qianhe.system.domain.WaterOrderGoods;
import com.qianhe.system.mapper.WaterOrderGoodsMapper;
import com.qianhe.system.service.IWaterOrderGoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 订单商品Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterOrderGoodsServiceImpl implements IWaterOrderGoodsService
{
    @Autowired
    private WaterOrderGoodsMapper waterOrderGoodsMapper;

    /**
     * 查询订单商品
     *
     * @param id 订单商品主键
     * @return 订单商品
     */
    @Override
    public WaterOrderGoods selectWaterOrderGoodsById(Long id)
    {
        return waterOrderGoodsMapper.selectWaterOrderGoodsById(id);
    }

    /**
     * 查询订单商品列表
     *
     * @param waterOrderGoods 订单商品
     * @return 订单商品
     */
    @Override
    public List<WaterOrderGoods> selectWaterOrderGoodsList(WaterOrderGoods waterOrderGoods)
    {
        return waterOrderGoodsMapper.selectWaterOrderGoodsList(waterOrderGoods);
    }

    /**
     * 新增订单商品
     *
     * @param waterOrderGoods 订单商品
     * @return 结果
     */
    @Override
    public int insertWaterOrderGoods(WaterOrderGoods waterOrderGoods)
    {
        return waterOrderGoodsMapper.insertWaterOrderGoods(waterOrderGoods);
    }

    /**
     * 修改订单商品
     *
     * @param waterOrderGoods 订单商品
     * @return 结果
     */
    @Override
    public int updateWaterOrderGoods(WaterOrderGoods waterOrderGoods)
    {
        return waterOrderGoodsMapper.updateWaterOrderGoods(waterOrderGoods);
    }

    /**
     * 批量删除订单商品
     *
     * @param ids 需要删除的订单商品主键
     * @return 结果
     */
    @Override
    public int deleteWaterOrderGoodsByIds(Long[] ids)
    {
        return waterOrderGoodsMapper.deleteWaterOrderGoodsByIds(ids);
    }

    /**
     * 删除订单商品信息
     *
     * @param id 订单商品主键
     * @return 结果
     */
    @Override
    public int deleteWaterOrderGoodsById(Long id)
    {
        return waterOrderGoodsMapper.deleteWaterOrderGoodsById(id);
    }
}
