package com.qianhe.system.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.system.domain.WaterGoodsType;
import com.qianhe.system.mapper.WaterGoodsTypeMapper;
import com.qianhe.system.service.IWaterGoodsTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 商品分类Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterGoodsTypeServiceImpl implements IWaterGoodsTypeService
{
    @Autowired
    private WaterGoodsTypeMapper waterGoodsTypeMapper;

    /**
     * 查询商品分类
     *
     * @param id 商品分类主键
     * @return 商品分类
     */
    @Override
    public WaterGoodsType selectWaterGoodsTypeById(Long id)
    {
        return waterGoodsTypeMapper.selectWaterGoodsTypeById(id);
    }

    /**
     * 查询商品分类列表
     *
     * @param waterGoodsType 商品分类
     * @return 商品分类
     */
    @Override
    public List<WaterGoodsType> selectWaterGoodsTypeList(WaterGoodsType waterGoodsType)
    {
        return waterGoodsTypeMapper.selectWaterGoodsTypeList(waterGoodsType);
    }

    /**
     * 新增商品分类
     *
     * @param waterGoodsType 商品分类
     * @return 结果
     */
    @Override
    public int insertWaterGoodsType(WaterGoodsType waterGoodsType)
    {
        waterGoodsType.setCreateTime(DateUtils.getNowDate());
        return waterGoodsTypeMapper.insertWaterGoodsType(waterGoodsType);
    }

    /**
     * 修改商品分类
     *
     * @param waterGoodsType 商品分类
     * @return 结果
     */
    @Override
    public int updateWaterGoodsType(WaterGoodsType waterGoodsType)
    {
        return waterGoodsTypeMapper.updateWaterGoodsType(waterGoodsType);
    }

    /**
     * 批量删除商品分类
     *
     * @param ids 需要删除的商品分类主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsTypeByIds(Long[] ids)
    {
        return waterGoodsTypeMapper.deleteWaterGoodsTypeByIds(ids);
    }

    /**
     * 删除商品分类信息
     *
     * @param id 商品分类主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsTypeById(Long id)
    {
        return waterGoodsTypeMapper.deleteWaterGoodsTypeById(id);
    }
}
