package com.qianhe.system.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.system.domain.WaterGoodsSpe;
import com.qianhe.system.domain.WaterGoodsSpeVal;
import com.qianhe.system.mapper.WaterGoodsSpeMapper;
import com.qianhe.system.service.IWaterGoodsSpeService;
import com.qianhe.system.vo.WaterGoodsSpeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 商品关联规格Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterGoodsSpeServiceImpl implements IWaterGoodsSpeService
{
    @Autowired
    private WaterGoodsSpeMapper waterGoodsSpeMapper;

    /**
     * 查询商品关联规格
     *
     * @param id 商品关联规格主键
     * @return 商品关联规格
     */
    @Override
    public WaterGoodsSpe selectWaterGoodsSpeById(Long id)
    {
        return waterGoodsSpeMapper.selectWaterGoodsSpeById(id);
    }

    /**
     * 查询商品关联规格列表
     *
     * @param waterGoodsSpe 商品关联规格
     * @return 商品关联规格
     */
    @Override
    public List<WaterGoodsSpe> selectWaterGoodsSpeList(WaterGoodsSpe waterGoodsSpe)
    {
        return waterGoodsSpeMapper.selectWaterGoodsSpeList(waterGoodsSpe);
    }

    /**
     * 新增商品关联规格
     *
     * @param waterGoodsSpeVo 商品关联规格
     * @return 结果
     */
    @Override
    public int insertWaterGoodsSpe(WaterGoodsSpeVo waterGoodsSpeVo)
    {
        waterGoodsSpeVo.setCreateTime(DateUtils.getNowDate());
        return waterGoodsSpeMapper.insertWaterGoodsSpe(waterGoodsSpeVo);
    }

    /**
     * 修改商品关联规格
     *
     * @param waterGoodsSpeVo 商品关联规格
     * @return 结果
     */
    @Override
    public int updateWaterGoodsSpe(WaterGoodsSpeVo waterGoodsSpeVo)
    {
        return waterGoodsSpeMapper.updateWaterGoodsSpe(waterGoodsSpeVo);
    }

    /**
     * 批量删除商品关联规格
     *
     * @param ids 需要删除的商品关联规格主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsSpeByIds(Long[] ids)
    {
        return waterGoodsSpeMapper.deleteWaterGoodsSpeByIds(ids);
    }

    /**
     * 删除商品关联规格信息
     *
     * @param id 商品关联规格主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsSpeById(Long id)
    {
        return waterGoodsSpeMapper.deleteWaterGoodsSpeById(id);
    }

    /**
     * 查询商品关联规格值列表
     * @param waterGoodsSpeVal 商品关联规格值
     * @return
     */
    @Override
    public List<WaterGoodsSpeVal> selectWaterGoodsSpeValList(WaterGoodsSpeVal waterGoodsSpeVal) {
        return waterGoodsSpeMapper.selectWaterGoodsSpeValList(waterGoodsSpeVal);
    }
}
