package com.qianhe.system.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.domain.*;
import com.qianhe.system.mapper.*;
import com.qianhe.system.service.IWaterGoodsService;
import com.qianhe.system.utils.GraphUtils;
//import com.qianhe.system.utils.ImageThumbnailsUtil;
import com.qianhe.system.vo.WaterGoodsSpeVo;
import com.qianhe.system.vo.WaterGoodsVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 商品Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterGoodsServiceImpl implements IWaterGoodsService
{
    @Value("${ruoyi.profile}")
    private String profile;
    @Autowired
    private WaterGoodsMapper waterGoodsMapper;
    @Autowired
    private WaterGoodsSpeMapper waterGoodsSpeMapper;
    @Autowired
    private WaterGoodsImgMapper waterGoodsImgMapper;
    @Autowired
    private WaterStationMapper waterStationMapper;
    @Autowired
    private WaterGoodsTypeMapper waterGoodsTypeMapper;
    @Autowired
    private WaterGoodsCartMapper waterGoodsCartMapper;
//    @Autowired
//    private ImageThumbnailsUtil imageThumbnailsUtil;

    /**
     * 查询商品
     *
     * @param id 商品主键
     * @return 商品
     */
    @Override
    public WaterGoodsVo selectWaterGoodsById(Long id)
    {
        WaterGoods waterGoods = waterGoodsMapper.selectWaterGoodsById1(id);
        WaterGoods goodsPrice = waterGoodsMapper.getPriceByID(id);
        waterGoods.setPrice(goodsPrice.getPrice());
        waterGoods.setSjjg(goodsPrice.getSjjg());

        //转vo
        WaterGoodsVo waterGoodsVo = new WaterGoodsVo();
        BeanUtils.copyProperties(waterGoods,waterGoodsVo);
        //查询所有站点
        List<WaterStation> waterStations = waterStationMapper.selectWaterStationList(new WaterStation());
        //查询所有商品分类
        List<WaterGoodsType> waterGoodsTypes = waterGoodsTypeMapper.selectWaterGoodsTypeList(new WaterGoodsType());
        //查询商品图片
        WaterGoodsImg waterGoodsImg = new WaterGoodsImg();
        waterGoodsImg.setGoodsId(id);
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgMapper.selectWaterGoodsImgList(waterGoodsImg);
        //查询商品规格
        WaterGoodsSpe waterGoodsSpe = new WaterGoodsSpe();
        waterGoodsSpe.setGoodsId(id);
        List<WaterGoodsSpe> waterGoodsSpes = waterGoodsSpeMapper.selectWaterGoodsSpeList(waterGoodsSpe);
        List<WaterGoodsSpeVo> waterGoodsSpeVoList = new ArrayList<>();
        if (waterGoodsSpes.size() > 0){
            for (WaterGoodsSpe goodsSpe : waterGoodsSpes) {
                //转vo
                WaterGoodsSpeVo waterGoodsSpeVo = new WaterGoodsSpeVo();
                BeanUtils.copyProperties(goodsSpe,waterGoodsSpeVo);

                WaterGoodsSpeVal waterGoodsSpeVal = new WaterGoodsSpeVal();
                waterGoodsSpeVal.setSpeId(goodsSpe.getId());
                List<WaterGoodsSpeVal> waterGoodsSpeVals = waterGoodsSpeMapper.selectWaterGoodsSpeValList(waterGoodsSpeVal);
                if (waterGoodsSpeVals.size() > 0){
                    waterGoodsSpeVo.setWaterGoodsSpeValList(waterGoodsSpeVals);
                }
                waterGoodsSpeVoList.add(waterGoodsSpeVo);
            }
        }
        if (waterGoodsSpeVoList.size() > 0){
            waterGoodsVo.setWaterGoodsSpe(waterGoodsSpeVoList.get(0));
        }
        List<WaterGoodsImg> coverImgs = new ArrayList<>();
        List<WaterGoodsImg> detailsImgs = new ArrayList<>();
        for (WaterGoodsImg waterGoodsImg1 : waterGoodsImgs) {
            if (waterGoodsImg1.getImgType() == 1){
                //商品封面图
                coverImgs.add(waterGoodsImg1);
            }
            if (waterGoodsImg1.getImgType() == 2){
                //商品详情图
                detailsImgs.add(waterGoodsImg1);
            }
        }
        if (coverImgs.size() > 0){
            waterGoodsVo.setCoverImgs(coverImgs);
        }
        if (detailsImgs.size() > 0){
            waterGoodsVo.setDetailsImgs(detailsImgs);
        }
        //设置站点名称
        if (StringUtils.isNotEmpty(waterGoods.getBelongStationId())){
            String[] split = waterGoods.getBelongStationId().split(",");
            String stationName = "";
            if (split.length > 1){
                for (int i = 0; i < split.length; i++) {
                    for (WaterStation waterStation : waterStations) {
                        if (split[i].equals(waterStation.getId().toString())){
                            if (i == split.length - 1){
                                stationName += waterStation.getStationName();
                            }else {
                                stationName += waterStation.getStationName() + ",";
                            }
                        }
                    }
                }
            }else {
                for (WaterStation waterStation : waterStations) {
                    if (split[0].equals(waterStation.getId().toString())){
                        stationName = waterStation.getStationName();
                    }
                }
            }
            waterGoodsVo.setBelongStationNames(stationName);
        }
        //设置商品分类名称
        if (StringUtils.isNotNull(waterGoods.getGoodsTypeId())){
            for (WaterGoodsType waterGoodsType : waterGoodsTypes) {
                if (waterGoods.getGoodsTypeId().equals(waterGoodsType.getId())){
                    waterGoodsVo.setGoodsTypeName(waterGoodsType.getTypeName());
                }
            }
        }
        //默认商品数量为1
        waterGoodsVo.setGoodsNum(1);
        return waterGoodsVo;
    }

    /**
     * 查询商品列表
     *
     * @param waterGoods 商品
     * @return 商品
     */
    @Override
    public List<WaterGoods> selectWaterGoodsList(WaterGoods waterGoods)
    {
        return waterGoodsMapper.selectWaterGoodsList(waterGoods);
    }

    /**
     * 主页轮播图
     * @param
     * @return
     */
    @Override
    public List<WaterGoods> selectWaterGoodsList1() {
        return waterGoodsMapper.selectWaterGoodsList1();
    }

    /**
     * 新增商品
     *
     * @param waterGoodsVo 商品
     * @return 结果
     */
    @Override
    @Transactional
    public int insertWaterGoods(WaterGoodsVo waterGoodsVo) throws IOException {
        waterGoodsVo.setCreateUser(SecurityUtils.getLoginUser().getUsername());
        waterGoodsVo.setCreateTime(DateUtils.getNowDate());
        int i = waterGoodsMapper.insertWaterGoods(waterGoodsVo);
        //新增封面图
        insertGoodsCoverImgs(waterGoodsVo);
        //新增详情图
        insertGoodsDetailsImgs(waterGoodsVo);
        //新增商品关联规格
        insertWaterGoodsSpe(waterGoodsVo);
        return i;
    }
    /**
     * 修改商品
     *
     * @param waterGoodsVo 商品
     * @return 结果
     */
    @Override
    public int updateWaterGoods(WaterGoodsVo waterGoodsVo)  throws IOException {
        //删除商品图片
        waterGoodsMapper.deleteWaterGoodsImgByGoodsId(waterGoodsVo.getId());
        //删除商品关联规格
        waterGoodsMapper.deleteWaterGoodsSpeByGoodsId(waterGoodsVo.getId());
        //新增封面图
        insertGoodsCoverImgs(waterGoodsVo);
        //新增详情图
        insertGoodsDetailsImgs(waterGoodsVo);
        //新增商品关联规格
        insertWaterGoodsSpe(waterGoodsVo);
        //判断商品是否下架，下架后该商品不可在进行购买，所有用户购物车中如有该商品，则状态改为已下架，不可进行购买
        if(StringUtils.isNotNull(waterGoodsVo.getStatus())){
                //下架状态  修改所有用户购物车中该商品的状态
                WaterGoodsCart waterGoodsCart = new WaterGoodsCart();
                waterGoodsCart.setGoodsId(waterGoodsVo.getId());
                waterGoodsCart.setStatus(waterGoodsVo.getStatus().toString());
                waterGoodsCartMapper.updateGoodsStatus(waterGoodsCart);
        }
        return waterGoodsMapper.updateWaterGoods(waterGoodsVo);
    }

    /**
     * 新增商品关联规格
     * @param waterGoodsVo
     */
    private void insertWaterGoodsSpe(WaterGoodsVo waterGoodsVo) {
        WaterGoodsSpeVo waterGoodsSpe = waterGoodsVo.getWaterGoodsSpe();
        //新增商品关联规格
        if (StringUtils.isNotNull(waterGoodsSpe)){
            waterGoodsSpe.setGoodsId(waterGoodsVo.getId());
            waterGoodsSpe.setCreateUser("管理员");
            waterGoodsSpe.setCreateTime(DateUtils.getNowDate());
            waterGoodsSpeMapper.insertWaterGoodsSpe(waterGoodsSpe);
        }
        List<WaterGoodsSpeVal> waterGoodsSpeValList = waterGoodsSpe.getWaterGoodsSpeValList();
        List<WaterGoodsSpeVal> waterGoodsSpeVals = new ArrayList<>();
        //商品关联规格主键id
        Long speId = waterGoodsSpe.getId();

        if (StringUtils.isNotNull(waterGoodsSpeValList)){
            for (WaterGoodsSpeVal waterGoodsSpeVal : waterGoodsSpeValList) {
                waterGoodsSpeVal.setSpeId(speId);
                waterGoodsSpeVals.add(waterGoodsSpeVal);
            }
        }
        if (waterGoodsSpeVals.size() > 0){
            //批量新增商品关联规格值
            waterGoodsSpeMapper.batchInsertWaterGoodsSpeVal(waterGoodsSpeVals);
        }
    }

    /**
     * 新增详情图
     * @param waterGoodsVo
     */
    private void insertGoodsDetailsImgs(WaterGoodsVo waterGoodsVo) throws IOException {
        List<WaterGoodsImg> detailsImgs = waterGoodsVo.getDetailsImgs();

        //图片压缩
//        if (StringUtils.isNotNull(detailsImgs)){
//            for (WaterGoodsImg detailsImg : detailsImgs) {
//                String inputImage = detailsImg.getUrl();
//                String outputImage = detailsImg.getUrl();
//                String inputImage =profile + detailsImg.getUrl().replace("/profile","");
//                inputImage= inputImage.replace("/prod-api","");
//                String outputImageDz = inputImage.substring(0,inputImage.lastIndexOf("/"));
//                Thumbnails.of(inputImage)
//                        // 图片缩放率，不能和size()一起使用
//                        .scale(0.7d)// 缩略图保存目录,该目录需存在，否则报错
//                        .toFiles(new File(outputImageDz), Rename.NO_CHANGE);
//                //判断图片是否是jpg或jpeg
//                String hz = detailsImg.getUrl().substring(detailsImg.getUrl().lastIndexOf(".") + 1);
//                if (hz.equals("jpg") || hz.equals("jpeg")){
//                    try {
//                        imageThumbnailsUtil.compressImage(inputImage,outputImage);
//                    } catch (IOException e) {
//                        e.printStackTrace();
//                    }
//                }else {
//                    try {
//                        imageThumbnailsUtil.compressImagePNG(inputImage,outputImage);
//                    } catch (IOException e) {
//                        e.printStackTrace();
//                    }
//                }
//            }
//        }
        List<WaterGoodsImg> detailsImgList = new ArrayList<>();
        //商品主键id
        Long id = waterGoodsVo.getId();
        if (StringUtils.isNotNull(detailsImgs)){
            for (WaterGoodsImg detailsImg : detailsImgs) {
                detailsImg.setGoodsId(id);
                detailsImg.setImgType(2);
                detailsImgList.add(detailsImg);
            }
        }
        if (detailsImgList.size() > 0){
            //批量新增详情图
            waterGoodsMapper.batchInsertWaterGoodsImgs(detailsImgList);
        }
    }




    /**
     * 新增封面图
     * @param waterGoodsVo
     */
    private void insertGoodsCoverImgs(WaterGoodsVo waterGoodsVo) throws IOException {
        List<WaterGoodsImg> coverImgs = waterGoodsVo.getCoverImgs();

        //图片压缩
//        if (StringUtils.isNotNull(coverImgs)){
//            for (WaterGoodsImg coverImg : coverImgs) {
//                String inputImage =profile + coverImg.getUrl().replace("/profile","");
//                inputImage= inputImage.replace("/prod-api","");
//                String outputImageDz = inputImage.substring(0,inputImage.lastIndexOf("/"));
//                Thumbnails.of(inputImage)
//                        // 图片缩放率，不能和size()一起使用
//                        .scale(0.7d)// 缩略图保存目录,该目录需存在，否则报错
//                        .toFiles(new File(outputImageDz), Rename.NO_CHANGE);
                //旋转图片
                // 旋转180度
//                ImgUtil.rotate(ImageIO.read(FileUtil.file(outputImageDz)), 180);
                //判断图片是否是jpg或jpeg
//                String hz = coverImg.getUrl().substring(coverImg.getUrl().lastIndexOf(".") + 1);
//                if (hz.equals("jpg") || hz.equals("jpeg")){
//                    try {
//                        imageThumbnailsUtil.compressImage(inputImage,outputImage);
//                    } catch (IOException e) {
//                        e.printStackTrace();
//                    }
//                }else {
//                    try {
//                        imageThumbnailsUtil.compressImagePNG(inputImage,outputImage);
//                    } catch (IOException e) {
//                        e.printStackTrace();
//                    }
//                }
//            }
//        }

        List<WaterGoodsImg> coverImgList = new ArrayList<>();
        //商品主键id
        Long id = waterGoodsVo.getId();
        if (StringUtils.isNotNull(coverImgs)){
            for (WaterGoodsImg coverImg : coverImgs) {
                coverImg.setGoodsId(id);
                coverImg.setImgType(1);
                coverImgList.add(coverImg);
            }
        }
        if (coverImgList.size() > 0){
            //批量新增封面图
            waterGoodsMapper.batchInsertWaterGoodsImgs(coverImgList);
        }
    }

    /**
     * 批量删除商品
     *
     * @param ids 需要删除的商品主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsByIds(Long[] ids)
    {
        //删除商品图片
        waterGoodsMapper.deleteWaterGoodsImgByGoodsIds(ids);
        //删除商品关联规格
        waterGoodsMapper.deleteWaterGoodsSpeByGoodsIds(ids);
        return waterGoodsMapper.deleteWaterGoodsByIds(ids);
    }

    /**
     * 删除商品信息
     *
     * @param id 商品主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsById(Long id)
    {
        return waterGoodsMapper.deleteWaterGoodsById(id);
    }

    /**
     * 水票商品信息
     * @return
     */
    @Override
    public WaterGoodsVo getGoodsSp() {
        WaterGoods waterGoods = waterGoodsMapper.selectGoodsSp();
        //转vo
        WaterGoodsVo waterGoodsVo = new WaterGoodsVo();
        BeanUtils.copyProperties(waterGoods,waterGoodsVo);
        //查询所有站点
        List<WaterStation> waterStations = waterStationMapper.selectWaterStationList(new WaterStation());
        //查询所有商品分类
        List<WaterGoodsType> waterGoodsTypes = waterGoodsTypeMapper.selectWaterGoodsTypeList(new WaterGoodsType());
        //查询商品图片
        WaterGoodsImg waterGoodsImg = new WaterGoodsImg();
        waterGoodsImg.setGoodsId(waterGoods.getId());
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgMapper.selectWaterGoodsImgList(waterGoodsImg);
        //查询商品规格
        WaterGoodsSpe waterGoodsSpe = new WaterGoodsSpe();
        waterGoodsSpe.setGoodsId(waterGoods.getId());
        List<WaterGoodsSpe> waterGoodsSpes = waterGoodsSpeMapper.selectWaterGoodsSpeList(waterGoodsSpe);
        List<WaterGoodsSpeVo> waterGoodsSpeVoList = new ArrayList<>();
        if (waterGoodsSpes.size() > 0){
            for (WaterGoodsSpe goodsSpe : waterGoodsSpes) {
                //转vo
                WaterGoodsSpeVo waterGoodsSpeVo = new WaterGoodsSpeVo();
                BeanUtils.copyProperties(goodsSpe,waterGoodsSpeVo);

                WaterGoodsSpeVal waterGoodsSpeVal = new WaterGoodsSpeVal();
                waterGoodsSpeVal.setSpeId(goodsSpe.getId());
                List<WaterGoodsSpeVal> waterGoodsSpeVals = waterGoodsSpeMapper.selectWaterGoodsSpeValList(waterGoodsSpeVal);
                if (waterGoodsSpeVals.size() > 0){
                    waterGoodsSpeVo.setWaterGoodsSpeValList(waterGoodsSpeVals);
                }
                waterGoodsSpeVoList.add(waterGoodsSpeVo);
            }
        }
        if (waterGoodsSpeVoList.size() > 0){
            waterGoodsVo.setWaterGoodsSpe(waterGoodsSpeVoList.get(0));
        }
        List<WaterGoodsImg> coverImgs = new ArrayList<>();
        List<WaterGoodsImg> detailsImgs = new ArrayList<>();
        for (WaterGoodsImg waterGoodsImg1 : waterGoodsImgs) {
            if (waterGoodsImg1.getImgType() == 1){
                //商品封面图
                coverImgs.add(waterGoodsImg1);
            }
            if (waterGoodsImg1.getImgType() == 2){
                //商品详情图
                detailsImgs.add(waterGoodsImg1);
            }
        }
        if (coverImgs.size() > 0){
            waterGoodsVo.setCoverImgs(coverImgs);
        }
        if (detailsImgs.size() > 0){
            waterGoodsVo.setDetailsImgs(detailsImgs);
        }
        //设置站点名称
        if (StringUtils.isNotEmpty(waterGoods.getBelongStationId())){
            String[] split = waterGoods.getBelongStationId().split(",");
            String stationName = "";
            if (split.length > 1){
                for (int i = 0; i < split.length; i++) {
                    for (WaterStation waterStation : waterStations) {
                        if (split[i].equals(waterStation.getId().toString())){
                            if (i == split.length - 1){
                                stationName += waterStation.getStationName();
                            }else {
                                stationName += waterStation.getStationName() + ",";
                            }
                        }
                    }
                }
            }else {
                for (WaterStation waterStation : waterStations) {
                    if (split[0].equals(waterStation.getId().toString())){
                        stationName = waterStation.getStationName();
                    }
                }
            }
            waterGoodsVo.setBelongStationNames(stationName);
        }
        //设置商品分类名称
        if (StringUtils.isNotNull(waterGoods.getGoodsTypeId())){
            for (WaterGoodsType waterGoodsType : waterGoodsTypes) {
                if (waterGoods.getGoodsTypeId().equals(waterGoodsType.getId())){
                    waterGoodsVo.setGoodsTypeName(waterGoodsType.getTypeName());
                }
            }
        }
        //默认商品数量为1
        waterGoodsVo.setGoodsNum(1);
        return waterGoodsVo;
    }

    /**
     * 获取选中的商品信息
     * @param waterGoodsVo
     * @return
     */
    @Override
    public WaterGoodsVo getGoodsXq(WaterGoodsVo waterGoodsVo) {
        //根据商品id查询商品详细信息
        WaterGoods waterGoods = waterGoodsMapper.selectWaterGoodsById1(waterGoodsVo.getId());
        //转vo
        WaterGoodsVo waterGoodsVo1 = new WaterGoodsVo();
        BeanUtils.copyProperties(waterGoods,waterGoodsVo1);
        waterGoodsVo1.setGoodsId(waterGoodsVo.getId());
        waterGoodsVo1.setGoodsSpeId(waterGoodsVo.getGoodsSpeId());
        waterGoodsVo1.setGoodsSpeValId(waterGoodsVo.getGoodsSpeValId());
        //根据商品关联规格值id查询商品关联规格值
        WaterGoodsSpeVal waterGoodsSpeVal = waterGoodsSpeMapper.selectWaterGoodsSpeValById(waterGoodsVo.getGoodsSpeValId());
        waterGoodsVo1.setGoodsSpeVal(waterGoodsSpeVal.getSpe() + "*" + waterGoodsSpeVal.getSpeVal());
        waterGoodsVo1.setPrice(waterGoodsSpeVal.getPrice());
        waterGoodsVo1.setSpe(waterGoodsSpeVal.getSpe() );
        waterGoodsVo1.setSpeVal(waterGoodsSpeVal.getSpeVal() );
        //查询商品图片
        WaterGoodsImg waterGoodsImg = new WaterGoodsImg();
        waterGoodsImg.setGoodsId(waterGoodsVo.getId());
        List<WaterGoodsImg> waterGoodsImgs = waterGoodsImgMapper.selectWaterGoodsImgList(waterGoodsImg);
        List<WaterGoodsImg> coverImgs = new ArrayList<>();
        List<WaterGoodsImg> detailsImgs = new ArrayList<>();
        for (WaterGoodsImg waterGoodsImg1 : waterGoodsImgs) {
            if (waterGoodsImg1.getImgType() == 1){
                //商品封面图
                coverImgs.add(waterGoodsImg1);
            }
            if (waterGoodsImg1.getImgType() == 2){
                //商品详情图
                detailsImgs.add(waterGoodsImg1);
            }
        }
        if (coverImgs.size() > 0){
            waterGoodsVo1.setCoverImgs(coverImgs);
        }
        if (detailsImgs.size() > 0){
            waterGoodsVo1.setDetailsImgs(detailsImgs);
        }
        waterGoodsVo1.setGoodsNum(1);
        waterGoodsVo1.setOrderGoodsType(1);
        return waterGoodsVo1;
    }

    @Override
    public int savelbt(WaterGoodsImg waterGoodsImg) {
        //分类为轮播图
        waterGoodsImg.setImgType(3);
        return waterGoodsImgMapper.insertWaterGoodsImg(waterGoodsImg);
    }




}
