package com.qianhe.system.service.impl;

import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.mapper.WaterGoodsImgMapper;
import com.qianhe.system.service.IWaterGoodsImgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 商品图片Service业务层处理
 *
 * @author qianhe
 * @date 2023-11-23
 */
@Service
public class WaterGoodsImgServiceImpl implements IWaterGoodsImgService
{
    @Autowired
    private WaterGoodsImgMapper waterGoodsImgMapper;

    /**
     * 查询商品图片
     *
     * @param id 商品图片主键
     * @return 商品图片
     */
    @Override
    public WaterGoodsImg selectWaterGoodsImgById(Long id)
    {
        return waterGoodsImgMapper.selectWaterGoodsImgById(id);
    }

    /**
     * 查询商品图片列表
     *
     * @param waterGoodsImg 商品图片
     * @return 商品图片
     */
    @Override
    public List<WaterGoodsImg> selectWaterGoodsImgList(WaterGoodsImg waterGoodsImg)
    {
        return waterGoodsImgMapper.selectWaterGoodsImgList(waterGoodsImg);
    }

    /**
     * 新增商品图片
     *
     * @param waterGoodsImg 商品图片
     * @return 结果
     */
    @Override
    public int insertWaterGoodsImg(WaterGoodsImg waterGoodsImg)
    {
        return waterGoodsImgMapper.insertWaterGoodsImg(waterGoodsImg);
    }

    /**
     * 修改商品图片
     *
     * @param waterGoodsImg 商品图片
     * @return 结果
     */
    @Override
    public int updateWaterGoodsImg(WaterGoodsImg waterGoodsImg)
    {
        return waterGoodsImgMapper.updateWaterGoodsImg(waterGoodsImg);
    }

    /**
     * 批量删除商品图片
     *
     * @param ids 需要删除的商品图片主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsImgByIds(Long[] ids)
    {
        return waterGoodsImgMapper.deleteWaterGoodsImgByIds(ids);
    }

    /**
     * 删除商品图片信息
     *
     * @param id 商品图片主键
     * @return 结果
     */
    @Override
    public int deleteWaterGoodsImgById(Long id)
    {
        return waterGoodsImgMapper.deleteWaterGoodsImgById(id);
    }
}
