package com.qianhe.system.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.system.domain.WaterGoods;
import com.qianhe.system.domain.WaterGoodsCart;
import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.domain.WaterGoodsSpeVal;
import com.qianhe.system.mapper.WaterGoodsCartMapper;
import com.qianhe.system.mapper.WaterGoodsImgMapper;
import com.qianhe.system.mapper.WaterGoodsMapper;
import com.qianhe.system.mapper.WaterGoodsSpeMapper;
import com.qianhe.system.service.IWaterGoodsCartService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

@Service
public class WaterGoodsCartServiceImpl implements IWaterGoodsCartService {

    @Autowired
    private WaterGoodsCartMapper waterGoodsCartMapper;
    @Autowired
    private WaterGoodsMapper waterGoodsMapper;
    @Autowired
    private WaterGoodsSpeMapper waterGoodsSpeMapper;
    @Autowired
    private WaterGoodsImgMapper waterGoodsImgMapper;

    /**
     * 查询购物车列表
     * @param waterGoodsCart
     * @return
     */
    @Override
    public List<WaterGoodsCart> selectWaterGoodsCartList(WaterGoodsCart waterGoodsCart) {
        return waterGoodsCartMapper.selectWaterGoodsCartList(waterGoodsCart);
    }

    /**
     * 查询详情
     * @param id
     * @return
     */
    @Override
    public WaterGoodsCart selectWaterGoodsCartById(Long id) {
        return waterGoodsCartMapper.selectWaterGoodsCartById(id);
    }

    /**
     * 新增购物商品
     * @param waterGoodsCart
     * @return
     */
    @Override
    @Transactional
    public int insertWaterGoodsCart(WaterGoodsCart waterGoodsCart) {
        //根据商品信息查询该规格商品是否已经存在购物车中
        List<WaterGoodsCart> list = selectWaterGoodsCartList(waterGoodsCart);
        if (list.size() > 0){
            //如果该用户购物车中存在该规格商品，则购物车商品数量+1
            WaterGoodsCart waterGoodsCart1 = list.get(0);
            WaterGoodsCart waterGoodsCart2 = new WaterGoodsCart();
            waterGoodsCart2.setId(waterGoodsCart1.getId());
            waterGoodsCart2.setGoodsNum(waterGoodsCart1.getGoodsNum() + 1);
            waterGoodsCart2.setGoodsTotal(BigDecimal.valueOf(waterGoodsCart1.getGoodsPrice().doubleValue() * waterGoodsCart2.getGoodsNum()));
            return waterGoodsCartMapper.updateWaterGoodsCart(waterGoodsCart2);
        }
        //根据商品id查询商品信息
        WaterGoods waterGoods = waterGoodsMapper.selectWaterGoodsById1(waterGoodsCart.getGoodsId());
        //根据规格值id查询规格值
        WaterGoodsSpeVal waterGoodsSpeVal = waterGoodsSpeMapper.selectWaterGoodsSpeValById(waterGoodsCart.getGoodsSpeValId());
        waterGoodsCart.setGoodsName(waterGoods.getTitle());
        waterGoodsCart.setGoodsTypeId(waterGoods.getGoodsTypeId());
        waterGoodsCart.setGoodsSpeVal(waterGoodsSpeVal.getSpe() + "*" + waterGoodsSpeVal.getSpeVal());
        waterGoodsCart.setGoodsPrice(waterGoodsSpeVal.getPrice());
        waterGoodsCart.setGoodsTotal(waterGoodsSpeVal.getPrice());
        waterGoodsCart.setCreateUser(waterGoodsCart.getUserId().toString());
        waterGoodsCart.setSpeVal(waterGoodsSpeVal.getSpeVal());
        waterGoodsCart.setGoodsNum(1);
        waterGoodsCart.setCreateTime(DateUtils.getNowDate());
        return waterGoodsCartMapper.insertWaterGoodsCart(waterGoodsCart);
    }

    /**
     * 修改购物车商品
     * @param waterGoodsCart
     * @return
     */
    @Override
    @Transactional
    public int updateWaterGoodsCart(WaterGoodsCart waterGoodsCart)
    {
        if (StringUtils.isNotNull(waterGoodsCart.getGoodsNum())){
            WaterGoodsCart waterGoodsCart1 = waterGoodsCartMapper.selectWaterGoodsCartById(waterGoodsCart.getId());
            waterGoodsCart.setGoodsTotal(BigDecimal.valueOf(waterGoodsCart1.getGoodsPrice().doubleValue() * waterGoodsCart.getGoodsNum()));
        }
        return waterGoodsCartMapper.updateWaterGoodsCart(waterGoodsCart);
    }

    /**
     * 批量删除购物车商品
     * @param ids
     * @return
     */
    @Override
    public int deleteWaterGoodsCartByIds(Long[] ids) {
        return waterGoodsCartMapper.deleteWaterGoodsCartByIds(ids);
    }

    /**
     * 根据购物车id查询购物车商品
     * @param ids
     * @return
     */
    @Override
    public List<WaterGoodsCart> selectWaterGoodsCartByIds(Long[] ids) {
        return waterGoodsCartMapper.selectWaterGoodsCartByIds(ids);
    }
}
