package com.qianhe.system.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.qianhe.common.core.domain.model.WxLoginBody;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.vo.WaterUserVo;

import java.util.List;
import java.util.Map;

/**
 * 用户Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterUserService extends IService<WaterUser>
{
    /**
     * 查询用户
     *
     * @param id 用户主键
     * @return 用户
     */
    public WaterUserVo selectWaterUserById(Long id);

    /**
     * 查询用户列表
     *
     * @param waterUser 用户
     * @return 用户集合
     */
    public List<WaterUser> selectWaterUserList(WaterUser waterUser);

    /**
     * 新增用户
     *
     * @param waterUser 用户
     * @return 结果
     */
    public int insertWaterUser(WaterUser waterUser);

    /**
     * 修改用户
     *
     * @param waterUser 用户
     * @return 结果
     */
    public int updateWaterUser(WaterUser waterUser);

    /**
     * 批量删除用户
     *
     * @param ids 需要删除的用户主键集合
     * @return 结果
     */
    public int deleteWaterUserByIds(Long[] ids);

    /**
     * 删除用户信息
     *
     * @param id 用户主键
     * @return 结果
     */
    public int deleteWaterUserById(Long id);

    /**
     * 根据openid查询用户
     * @param openId
     * @return
     */
    WaterUser selectUserByOpenId(String openId,String userType);

    /**
     * 根据openid修改用户信息
     * @param waterUser
     * @return
     */
    int updateUserByOpenId(WaterUser waterUser);

    Map<String, Integer> getUserSl();

    Boolean getSfjz(WaterUser waterUser);
}
