package com.qianhe.system.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.qianhe.system.domain.WaterUserAddress;

import java.util.List;

/**
 * 用户地址Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterUserAddressService extends IService<WaterUserAddress>
{
    /**
     * 查询用户地址
     *
     * @param id 用户地址主键
     * @return 用户地址
     */
    public WaterUserAddress selectWaterUserAddressById(Long id);

    /**
     * 查询用户地址列表
     *
     * @param waterUserAddress 用户地址
     * @return 用户地址集合
     */
    public List<WaterUserAddress> selectWaterUserAddressList(WaterUserAddress waterUserAddress);

    /**
     * 新增用户地址
     *
     * @param waterUserAddress 用户地址
     * @return 结果
     */
    public int insertWaterUserAddress(WaterUserAddress waterUserAddress);

    /**
     * 修改用户地址
     *
     * @param waterUserAddress 用户地址
     * @return 结果
     */
    public int updateWaterUserAddress(WaterUserAddress waterUserAddress);

    /**
     * 批量删除用户地址
     *
     * @param ids 需要删除的用户地址主键集合
     * @return 结果
     */
    public int deleteWaterUserAddressByIds(Long[] ids);

    /**
     * 删除用户地址信息
     *
     * @param id 用户地址主键
     * @return 结果
     */
    public int deleteWaterUserAddressById(Long id);

    /**
     * 获取用户默认地址
     * @return
     */
    WaterUserAddress getUserDefaultAddress(Long userId);

    /**
     * 修改用户默认地址
     * @param waterUserAddress
     * @return
     */
    int updateDefaultAddress(WaterUserAddress waterUserAddress);
}
