package com.qianhe.system.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.qianhe.system.domain.WaterStationUser;
import com.qianhe.system.vo.WaterStationUserVo;

import java.util.List;

/**
 * 站点用户Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterStationUserService extends IService<WaterStationUser>
{
    /**
     * 查询站点用户
     *
     * @param id 站点用户主键
     * @return 站点用户
     */
    public WaterStationUser selectWaterStationUserById(Long id);

    /**
     * 查询站点用户列表
     *
     * @param waterStationUser 站点用户
     * @return 站点用户集合
     */
    public List<WaterStationUserVo> selectWaterStationUserList(WaterStationUser waterStationUser);

    /**
     * 新增站点用户
     *
     * @param waterStationUser 站点用户
     * @return 结果
     */
    public int insertWaterStationUser(WaterStationUser waterStationUser);

    /**
     * 修改站点用户
     *
     * @param waterStationUser 站点用户
     * @return 结果
     */
    public int updateWaterStationUser(WaterStationUser waterStationUser);

    /**
     * 批量删除站点用户
     *
     * @param ids 需要删除的站点用户主键集合
     * @return 结果
     */
    public int deleteWaterStationUserByIds(Long[] ids);

    /**
     * 删除站点用户信息
     *
     * @param id 站点用户主键
     * @return 结果
     */
    public int deleteWaterStationUserById(Long id);

    /**
     * 根据手机号查询站点用户
     *
     * @param phone 站点用户手机号
     * @return 站点用户
     */
    public WaterStationUserVo selectWaterStationUserByPhone(Long phone);
}
