package com.qianhe.system.service;

import com.qianhe.system.domain.WaterStation;
import com.qianhe.system.vo.WaterStationVo;

import java.util.List;
import java.util.Map;

/**
 * 站点Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterStationService
{
    /**
     * 查询站点
     *
     * @param id 站点主键
     * @return 站点
     */
    public WaterStationVo selectWaterStationById(Long id);

    /**
     * 查询站点列表
     *
     * @param waterStation 站点
     * @return 站点集合
     */
    public List<WaterStation> selectWaterStationList(WaterStation waterStation);

    /**
     * 新增站点
     *
     * @param waterStation 站点
     * @return 结果
     */
    public int insertWaterStation(WaterStation waterStation);

    /**
     * 修改站点
     *
     * @param waterStation 站点
     * @return 结果
     */
    public int updateWaterStation(WaterStation waterStation);

    /**
     * 批量删除站点
     *
     * @param ids 需要删除的站点主键集合
     * @return 结果
     */
    public int deleteWaterStationByIds(Long[] ids);

    /**
     * 删除站点信息
     *
     * @param id 站点主键
     * @return 结果
     */
    public int deleteWaterStationById(Long id);

    /**
     * 修改是否营业
     * @param waterStation
     * @return
     */
    int updateIsOpen(WaterStation waterStation);

    /**
     * 查询站点下拉框
     *
     * @return 站点集合
     */
    public List<WaterStationVo> getStationList(double lon, double lat,String stationName);

    /**
     * 查询最新站点
     * @param lon
     * @param lat
     * @return
     */
    WaterStationVo getRecentlyStation(double lon, double lat);


    /**
     * 下单页查询最新站点
     * @param lon
     * @param lat
     * @return
     */
    WaterStationVo getRecentlyStation1(String address,String address1);

    /**
     * 查询站点下拉框（PC端）
     * @return
     */
    List<WaterStation> getWaterStationList();

    WaterStationVo getRecentlyStation2(String address, String address1);

}
