package com.qianhe.system.service;

import java.util.List;
import com.qianhe.system.domain.WaterStationRegion;

/**
 * 站点区域范围Service接口
 * 
 * @author qianhe
 * @date 2024-04-15
 */
public interface IWaterStationRegionService 
{
    /**
     * 查询站点区域范围
     * 
     * @param ID 站点区域范围主键
     * @return 站点区域范围
     */
    public WaterStationRegion selectWaterStationRegionByID(Long ID);

    /**
     * 查询站点区域范围列表
     * 
     * @param waterStationRegion 站点区域范围
     * @return 站点区域范围集合
     */
    public List<WaterStationRegion> selectWaterStationRegionList(WaterStationRegion waterStationRegion);

    /**
     * 新增站点区域范围
     * 
     * @param waterStationRegion 站点区域范围
     * @return 结果
     */
    public int insertWaterStationRegion(WaterStationRegion waterStationRegion);

    /**
     * 修改站点区域范围
     * 
     * @param waterStationRegion 站点区域范围
     * @return 结果
     */
    public int updateWaterStationRegion(WaterStationRegion waterStationRegion);

    /**
     * 批量删除站点区域范围
     * 
     * @param IDs 需要删除的站点区域范围主键集合
     * @return 结果
     */
    public int deleteWaterStationRegionByIDs(Long[] IDs);

    /**
     * 删除站点区域范围信息
     * 
     * @param ID 站点区域范围主键
     * @return 结果
     */
    public int deleteWaterStationRegionByID(Long ID);
}
