package com.qianhe.system.service;

import com.qianhe.system.domain.WaterSpe;
import com.qianhe.system.domain.WaterSpeVal;
import com.qianhe.system.vo.WaterSpeVo;

import java.util.List;

/**
 * 商品规格Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterSpeService
{
    /**
     * 查询商品规格
     *
     * @param id 商品规格主键
     * @return 商品规格
     */
    public WaterSpeVo selectWaterSpeById(Long id);

    /**
     * 查询商品规格列表
     *
     * @param waterSpe 商品规格
     * @return 商品规格集合
     */
    public List<WaterSpe> selectWaterSpeList(WaterSpe waterSpe);

    /**
     * 新增商品规格
     *
     * @param waterSpeVo 商品规格
     * @return 结果
     */
    public int insertWaterSpe(WaterSpeVo waterSpeVo);

    /**
     * 修改商品规格
     *
     * @param waterSpeVo 商品规格
     * @return 结果
     */
    public int updateWaterSpe(WaterSpeVo waterSpeVo);

    /**
     * 批量删除商品规格
     *
     * @param ids 需要删除的商品规格主键集合
     * @return 结果
     */
    public int deleteWaterSpeByIds(Long[] ids);

    /**
     * 删除商品规格信息
     *
     * @param id 商品规格主键
     * @return 结果
     */
    public int deleteWaterSpeById(Long id);

    List<WaterSpeVal> selectWaterSpeValList(WaterSpeVal waterSpeVal);
}
