package com.qianhe.system.service;

import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.system.domain.WaterOrder;
import com.qianhe.system.vo.WaterOrderVo;

import java.util.List;
import java.util.Map;

/**
 * 订单Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterOrderService
{
    /**
     * 查询订单
     *
     * @param id 订单主键
     * @return 订单
     */
    public WaterOrderVo selectWaterOrderById(Long id);

    /**
     * 查询订单列表
     *
     * @param waterOrderVo 订单
     * @return 订单集合
     */
    public List<WaterOrder> selectWaterOrderList(WaterOrderVo waterOrderVo);

    /**
     * 新增订单
     *
     * @param waterOrderVo 订单
     * @return 结果
     */
    public String insertWaterOrder(WaterOrderVo waterOrderVo);

    /**
     * 修改订单
     *
     * @param waterOrderVo 订单
     * @return 结果
     */
    public int updateWaterOrder(WaterOrderVo waterOrderVo);

    /**
     * 修改订单
     *
     * @param waterOrderVo 订单
     * @return 结果
     */
    public int updateWaterOrder1(WaterOrderVo waterOrderVo);

    /**
     * 批量删除订单
     *
     * @param ids 需要删除的订单主键集合
     * @return 结果
     */
    public int deleteWaterOrderByIds(Long[] ids);

    /**
     * 删除订单信息
     *
     * @param id 订单主键
     * @return 结果
     */
    public int deleteWaterOrderById(Long id);

    /**
     * 修改订单状态
     * @param waterOrderVo
     * @return
     */
    int updateOrderState(WaterOrderVo waterOrderVo);

    /**
     * 统计站点订单数量
     * @param stationId
     * @return
     */
    Map<String,Integer> getOrderNumByStation(Long stationId);

    /**
     * 根据站点查询订单
     *
     * @param waterOrderVo 订单
     * @return 订单集合
     */
    public List<WaterOrderVo> getWaterOrderListByStationId(WaterOrderVo waterOrderVo);

    /**
     * 修改订单完成状态（送水端）
     * @param waterOrderVo
     * @return
     */
    int updateCompleteState(WaterOrderVo waterOrderVo);

    /**
     * 修改订单确认状态（订水端）
     * @param waterOrderVo
     * @return
     */
    int updateConfirmState(WaterOrderVo waterOrderVo);

    Map<String,Integer> getOrderNumByUser(Long userId);

    /**
     * 查询今天和昨天的所有订单
     */
    List<WaterOrder> selectOrderListByTime();

    /**
     * PC端首页统计
     * @return
     */
    Map<String, Integer> countOrderNum();

    /**
     * 新增退款订单
     * @param waterOrderVo
     * @return
     */
    int addReturnOrder(WaterOrderVo waterOrderVo);

    /**
     * 修改待付款订单状态(订水端)
     * @param waterOrderVo
     * @return
     */
    int updateOrderPayType(WaterOrderVo waterOrderVo);

    AjaxResult gzhSend(WaterOrderVo vo);
}
