package com.qianhe.system.service;

import com.qianhe.system.domain.WaterOrderGoods;

import java.util.List;

/**
 * 订单商品Service接口
 * 
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterOrderGoodsService 
{
    /**
     * 查询订单商品
     * 
     * @param id 订单商品主键
     * @return 订单商品
     */
    public WaterOrderGoods selectWaterOrderGoodsById(Long id);

    /**
     * 查询订单商品列表
     * 
     * @param waterOrderGoods 订单商品
     * @return 订单商品集合
     */
    public List<WaterOrderGoods> selectWaterOrderGoodsList(WaterOrderGoods waterOrderGoods);

    /**
     * 新增订单商品
     * 
     * @param waterOrderGoods 订单商品
     * @return 结果
     */
    public int insertWaterOrderGoods(WaterOrderGoods waterOrderGoods);

    /**
     * 修改订单商品
     * 
     * @param waterOrderGoods 订单商品
     * @return 结果
     */
    public int updateWaterOrderGoods(WaterOrderGoods waterOrderGoods);

    /**
     * 批量删除订单商品
     * 
     * @param ids 需要删除的订单商品主键集合
     * @return 结果
     */
    public int deleteWaterOrderGoodsByIds(Long[] ids);

    /**
     * 删除订单商品信息
     * 
     * @param id 订单商品主键
     * @return 结果
     */
    public int deleteWaterOrderGoodsById(Long id);
}
