package com.qianhe.system.service;

import com.qianhe.system.domain.WaterGoodsSpe;
import com.qianhe.system.domain.WaterGoodsSpeVal;
import com.qianhe.system.vo.WaterGoodsSpeVo;

import java.util.List;

/**
 * 商品关联规格Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterGoodsSpeService
{
    /**
     * 查询商品关联规格
     *
     * @param id 商品关联规格主键
     * @return 商品关联规格
     */
    public WaterGoodsSpe selectWaterGoodsSpeById(Long id);

    /**
     * 查询商品关联规格列表
     *
     * @param waterGoodsSpe 商品关联规格
     * @return 商品关联规格集合
     */
    public List<WaterGoodsSpe> selectWaterGoodsSpeList(WaterGoodsSpe waterGoodsSpe);

    /**
     * 新增商品关联规格
     *
     * @param waterGoodsSpeVo 商品关联规格
     * @return 结果
     */
    public int insertWaterGoodsSpe(WaterGoodsSpeVo waterGoodsSpeVo);

    /**
     * 修改商品关联规格
     *
     * @param waterGoodsSpeVo 商品关联规格
     * @return 结果
     */
    public int updateWaterGoodsSpe(WaterGoodsSpeVo waterGoodsSpeVo);

    /**
     * 批量删除商品关联规格
     *
     * @param ids 需要删除的商品关联规格主键集合
     * @return 结果
     */
    public int deleteWaterGoodsSpeByIds(Long[] ids);

    /**
     * 删除商品关联规格信息
     *
     * @param id 商品关联规格主键
     * @return 结果
     */
    public int deleteWaterGoodsSpeById(Long id);

    /**
     * 查询商品关联规格值列表
     *
     * @param waterGoodsSpeVal 商品关联规格值
     * @return 商品关联规格值集合
     */
    public List<WaterGoodsSpeVal> selectWaterGoodsSpeValList(WaterGoodsSpeVal waterGoodsSpeVal);
}
