package com.qianhe.system.service;

import com.qianhe.system.domain.WaterGoods;
import com.qianhe.system.domain.WaterGoodsImg;
import com.qianhe.system.vo.WaterGoodsVo;

import java.io.IOException;
import java.util.List;

/**
 * 商品Service接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterGoodsService
{
    /**
     * 查询商品
     *
     * @param id 商品主键
     * @return 商品
     */
    public WaterGoodsVo selectWaterGoodsById(Long id);

    /**
     * 查询商品列表
     *
     * @param waterGoods 商品
     * @return 商品集合
     */
    public List<WaterGoods> selectWaterGoodsList(WaterGoods waterGoods);


    List<WaterGoods> selectWaterGoodsList1();

    /**
     * 新增商品
     *
     * @param waterGoodsVo 商品
     * @return 结果
     */
    public int insertWaterGoods(WaterGoodsVo waterGoodsVo) throws IOException;

    /**
     * 修改商品
     *
     * @param waterGoodsVo 商品
     * @return 结果
     */
    public int updateWaterGoods(WaterGoodsVo waterGoodsVo) throws IOException ;

    /**
     * 批量删除商品
     *
     * @param ids 需要删除的商品主键集合
     * @return 结果
     */
    public int deleteWaterGoodsByIds(Long[] ids);

    /**
     * 删除商品信息
     *
     * @param id 商品主键
     * @return 结果
     */
    public int deleteWaterGoodsById(Long id);

    /**
     * 水票商品信息
     * @return
     */
    WaterGoodsVo getGoodsSp();

    /**
     * 获取选中的商品信息
     * @param waterGoodsVo
     * @return
     */
    WaterGoodsVo getGoodsXq(WaterGoodsVo waterGoodsVo);

    int savelbt(WaterGoodsImg waterGoodsImg);

}
