package com.qianhe.system.service;

import com.qianhe.system.domain.WaterGoodsImg;

import java.util.List;

/**
 * 商品图片Service接口
 * 
 * @author qianhe
 * @date 2023-11-23
 */
public interface IWaterGoodsImgService 
{
    /**
     * 查询商品图片
     * 
     * @param id 商品图片主键
     * @return 商品图片
     */
    public WaterGoodsImg selectWaterGoodsImgById(Long id);

    /**
     * 查询商品图片列表
     * 
     * @param waterGoodsImg 商品图片
     * @return 商品图片集合
     */
    public List<WaterGoodsImg> selectWaterGoodsImgList(WaterGoodsImg waterGoodsImg);

    /**
     * 新增商品图片
     * 
     * @param waterGoodsImg 商品图片
     * @return 结果
     */
    public int insertWaterGoodsImg(WaterGoodsImg waterGoodsImg);

    /**
     * 修改商品图片
     * 
     * @param waterGoodsImg 商品图片
     * @return 结果
     */
    public int updateWaterGoodsImg(WaterGoodsImg waterGoodsImg);

    /**
     * 批量删除商品图片
     * 
     * @param ids 需要删除的商品图片主键集合
     * @return 结果
     */
    public int deleteWaterGoodsImgByIds(Long[] ids);

    /**
     * 删除商品图片信息
     * 
     * @param id 商品图片主键
     * @return 结果
     */
    public int deleteWaterGoodsImgById(Long id);
}
