package com.qianhe.system.service;

import com.qianhe.system.domain.WaterGoodsCart;

import java.util.List;

public interface IWaterGoodsCartService {

    /**
     * 查询购物车列表
     * @param waterGoodsCart
     * @return
     */
    List<WaterGoodsCart> selectWaterGoodsCartList(WaterGoodsCart waterGoodsCart);

    /**
     * 查询详情
     * @param id
     * @return
     */
    WaterGoodsCart selectWaterGoodsCartById(Long id);

    /**
     * 新增购物商品
     * @param waterGoodsCart
     * @return
     */
    int insertWaterGoodsCart(WaterGoodsCart waterGoodsCart);

    /**
     * 修改购物车商品
     * @param waterGoodsCart
     * @return
     */
    int updateWaterGoodsCart(WaterGoodsCart waterGoodsCart);

    /**
     * 批量删除购物车商品
     * @param ids
     * @return
     */
    int deleteWaterGoodsCartByIds(Long[] ids);

    /**
     * 根据购物车id查询购物车商品
     * @param ids
     * @return
     */
    List<WaterGoodsCart> selectWaterGoodsCartByIds(Long[] ids);
}
