package com.qianhe.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.qianhe.common.core.domain.model.WxLoginBody;
import com.qianhe.system.domain.WaterUser;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 用户Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterUserMapper extends BaseMapper<WaterUser>
{
    /**
     * 查询用户
     *
     * @param id 用户主键
     * @return 用户
     */
    public WaterUser selectWaterUserById(Long id);

    /**
     * 查询用户列表
     *
     * @param waterUser 用户
     * @return 用户集合
     */
    public List<WaterUser> selectWaterUserList(WaterUser waterUser);

    /**
     * 新增用户
     *
     * @param waterUser 用户
     * @return 结果
     */
    public int insertWaterUser(WaterUser waterUser);

    /**
     * 修改用户
     *
     * @param waterUser 用户
     * @return 结果
     */
    public int updateWaterUser(WaterUser waterUser);

    /**
     * 删除用户
     *
     * @param id 用户主键
     * @return 结果
     */
    public int deleteWaterUserById(Long id);

    /**
     * 批量删除用户
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterUserByIds(Long[] ids);

    /**
     * 根据openId查询用户
     * @param openId
     * @return
     */
    WaterUser selectUserByOpenId(@Param("openId") String openId,@Param("userType") String userType);

    /**
     * 根据openid修改用户信息
     * @param waterUser
     * @return
     */
    int updateUserByOpenId(WaterUser waterUser);

    /**
     * 批量删除用户地址
     *
     * @param ids 需要删除的用户id集合
     * @return 结果
     */
    int deleteWaterUserAddressByIds(Long[] ids);

    Map<String, Integer> getUserSl();

}
