package com.qianhe.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.qianhe.system.domain.WaterUserAddress;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户地址Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterUserAddressMapper extends BaseMapper<WaterUserAddress>
{
    /**
     * 查询用户地址
     *
     * @param id 用户地址主键
     * @return 用户地址
     */
    public WaterUserAddress selectWaterUserAddressById(Long id);

    /**
     * 查询用户地址列表
     *
     * @param waterUserAddress 用户地址
     * @return 用户地址集合
     */
    public List<WaterUserAddress> selectWaterUserAddressList(WaterUserAddress waterUserAddress);

    /**
     * 新增用户地址
     *
     * @param waterUserAddress 用户地址
     * @return 结果
     */
    public int insertWaterUserAddress(WaterUserAddress waterUserAddress);

    /**
     * 修改用户地址
     *
     * @param waterUserAddress 用户地址
     * @return 结果
     */
    public int updateWaterUserAddress(WaterUserAddress waterUserAddress);

    /**
     * 删除用户地址
     *
     * @param id 用户地址主键
     * @return 结果
     */
    public int deleteWaterUserAddressById(Long id);

    /**
     * 批量删除用户地址
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterUserAddressByIds(Long[] ids);

    /**
     * 获取用户默认地址
     * @return
     */
    WaterUserAddress getUserDefaultAddress(@Param("userId") Long userId);

    /**
     * 修改用户默认地址
     */
    int updateDefaultAddress(@Param("waterUserId") Long waterUserId);
}
