package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterText;

import java.util.List;

/**
 * 通知公告文本Mapper接口
 * 
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterTextMapper 
{
    /**
     * 查询通知公告文本
     * 
     * @param id 通知公告文本主键
     * @return 通知公告文本
     */
    public WaterText selectWaterTextById(Long id);

    /**
     * 查询通知公告文本列表
     * 
     * @param waterText 通知公告文本
     * @return 通知公告文本集合
     */
    public List<WaterText> selectWaterTextList(WaterText waterText);

    /**
     * 新增通知公告文本
     * 
     * @param waterText 通知公告文本
     * @return 结果
     */
    public int insertWaterText(WaterText waterText);

    /**
     * 修改通知公告文本
     * 
     * @param waterText 通知公告文本
     * @return 结果
     */
    public int updateWaterText(WaterText waterText);

    /**
     * 删除通知公告文本
     * 
     * @param id 通知公告文本主键
     * @return 结果
     */
    public int deleteWaterTextById(Long id);

    /**
     * 批量删除通知公告文本
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterTextByIds(Long[] ids);
}
