package com.qianhe.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.qianhe.system.domain.WaterStationUser;
import com.qianhe.system.domain.WaterUser;
import com.qianhe.system.vo.WaterStationUserVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 站点用户Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterStationUserMapper extends BaseMapper<WaterStationUser>
{
    /**
     * 查询站点用户
     *
     * @param id 站点用户主键
     * @return 站点用户
     */
    public WaterStationUser selectWaterStationUserById(Long id);

    /**
     * 查询站点用户列表
     *
     * @param waterStationUser 站点用户
     * @return 站点用户集合
     */
    public List<WaterStationUserVo> selectWaterStationUserList(WaterStationUser waterStationUser);

    /**
     * 新增站点用户
     *
     * @param waterStationUser 站点用户
     * @return 结果
     */
    public int insertWaterStationUser(WaterStationUser waterStationUser);

    /**
     * 修改站点用户
     *
     * @param waterStationUser 站点用户
     * @return 结果
     */
    public int updateWaterStationUser(WaterStationUser waterStationUser);

    /**
     * 删除站点用户
     *
     * @param id 站点用户主键
     * @return 结果
     */
    public int deleteWaterStationUserById(Long id);

    /**
     * 批量删除站点用户
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterStationUserByIds(Long[] ids);

    /**
     * 根据手机号查询站点用户
     * @param phone
     * @return
     */
    WaterStationUserVo selectWaterStationUserByPhone(@Param("phone") Long phone);

    int updateWaterStationUserByphone(WaterStationUserVo userVo);

    WaterStationUser selectUserByOpenId(String openId);


}
