package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterStation;
import com.qianhe.system.domain.WaterStationUser;
import com.qianhe.system.vo.WaterStationUserVo;
import com.qianhe.system.vo.WaterStationVo;

import java.util.List;
import java.util.Map;

/**
 * 站点Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterStationMapper
{
    /**
     * 查询站点
     *
     * @param id 站点主键
     * @return 站点
     */
    public WaterStation selectWaterStationById(Long id);

    /**
     * 查询站点列表
     *
     * @param waterStation 站点
     * @return 站点集合
     */
    public List<WaterStation> selectWaterStationList(WaterStation waterStation);

    /**
     * 查询站点下拉框
     *
     * @return 站点集合
     */
    public List<WaterStation> getStationList(WaterStation waterStation);

    /**
     * 新增站点
     *
     * @param waterStation 站点
     * @return 结果
     */
    public int insertWaterStation(WaterStation waterStation);

    /**
     * 修改站点
     *
     * @param waterStation 站点
     * @return 结果
     */
    public int updateWaterStation(WaterStation waterStation);

    /**
     * 删除站点
     *
     * @param id 站点主键
     * @return 结果
     */
    public int deleteWaterStationById(Long id);

    /**
     * 批量删除站点
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterStationByIds(Long[] ids);

    /**
     * 批量新增站点用户
     * @param waterStationUsers
     * @return
     */
    void batchInsertStationUser(List<WaterStationUserVo> waterStationUsers);

    /**
     * 删除站点用户
     * @param id
     */
    void deleteWaterStationUserByStationId(Long id);

    /**
     * 批量删除站点用户
     * @param ids
     */
    void deleteWaterStationUserByStationIds(Long[] ids);

}
