package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterSpe;
import com.qianhe.system.domain.WaterSpeVal;
import com.qianhe.system.vo.WaterSpeVo;

import java.util.List;

/**
 * 商品规格Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterSpeMapper
{
    /**
     * 查询商品规格
     *
     * @param id 商品规格主键
     * @return 商品规格
     */
    public WaterSpe selectWaterSpeById(Long id);

    /**
     * 查询商品规格列表
     *
     * @param waterSpe 商品规格
     * @return 商品规格集合
     */
    public List<WaterSpe> selectWaterSpeList(WaterSpe waterSpe);

    /**
     * 查询商品规格规格值列表
     *
     * @param waterSpeVal 商品规格规格值
     * @return 商品规格集合
     */
    public List<WaterSpeVal> selectWaterSpeValList(WaterSpeVal waterSpeVal);

    /**
     * 新增商品规格
     *
     * @param waterSpeVo 商品规格
     * @return 结果
     */
    public int insertWaterSpe(WaterSpeVo waterSpeVo);

    /**
     * 修改商品规格
     *
     * @param waterSpeVo 商品规格
     * @return 结果
     */
    public int updateWaterSpe(WaterSpeVo waterSpeVo);

    /**
     * 删除商品规格
     *
     * @param id 商品规格主键
     * @return 结果
     */
    public int deleteWaterSpeById(Long id);

    /**
     * 批量删除商品规格
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterSpeByIds(Long[] ids);

    /**
     * 删除商品规格规格值
     *
     * @param id 商品规格主键
     * @return 结果
     */
    public int deleteWaterSpeValBySpeId(Long id);


    int deleteWaterGoodsSpeValBySpeId(Long id);

    /**
     * 批量删除商品规格规格值
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterSpeValBySpeIds(Long[] ids);

    /**
     * 批量新增商品规格规格值
     * @param waterSpeVals
     */
    void batchInsertWaterSpeVal(List<WaterSpeVal> waterSpeVals);

    void batchInsertWaterGoodsSpeVal(List<WaterSpeVal> waterSpeVals);
}
