package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterOrder;
import com.qianhe.system.domain.WaterOrderGoods;
import com.qianhe.system.vo.WaterOrderVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 订单Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterOrderMapper
{
    /**
     * 查询订单
     *
     * @param id 订单主键
     * @return 订单
     */
    public WaterOrder selectWaterOrderById(Long id);

    /**
     * 根据订单编号查询订单
     *
     * @param orderNum 订单编号
     * @return 订单
     */
    public WaterOrder selectWaterOrderNumByOrderNum(String orderNum);

    /**
     * 查询订单列表
     *
     * @param waterOrderVo 订单
     * @return 订单集合
     */
    public List<WaterOrder> selectWaterOrderList(WaterOrderVo waterOrderVo);

    /**
     * 新增订单
     *
     * @param waterOrderVo 订单
     * @return 结果
     */
    public int insertWaterOrder(WaterOrderVo waterOrderVo);

    /**
     * 修改订单
     *
     * @param waterOrderVo 订单
     * @return 结果
     */
    public int updateWaterOrder(WaterOrderVo waterOrderVo);

    int updateByOrderNum(WaterOrderVo waterOrderVo);

    /**
     * 删除订单
     *
     * @param id 订单主键
     * @return 结果
     */
    public int deleteWaterOrderById(Long id);

    /**
     * 批量删除订单
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterOrderByIds(Long[] ids);

    /**
     * 删除订单商品
     *
     * @param id 订单主键
     * @return 结果
     */
    public int deleteWaterOrderGoodsByOrderId(Long id);

    /**
     * 批量删除订单商品
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterOrderGoodsByOrderIds(Long[] ids);

    /**
     * 批量新增订单商品
     * @param list
     */
    void batchInsertWaterOrderGoods(List<WaterOrderGoods> list);

    /**
     * 统计站点订单数量
     * @param waterOrderVo
     * @return
     */
    Map<String, Integer> getOrderNumByStation(WaterOrderVo waterOrderVo);
    Map<String, Integer> getOrderNumByStation1(WaterOrderVo waterOrderVo);
    Map<String, Integer> getOrderNumByStation2(WaterOrderVo waterOrderVo);

    /**
     * 根据站点查询订单
     *
     * @param waterOrderVo 订单
     * @return 订单集合
     */
    public List<WaterOrderVo> getWaterOrderListByStationId(WaterOrderVo waterOrderVo);

    Map<String,Integer> getOrderNumByUser(WaterOrderVo waterOrderVo);

    /**
     * 查询今天和昨天的所有订单
     */
    List<WaterOrder> selectOrderListByTime();

    /**
     * 统计每月普通订单
     * @return
     */
    List<Map<String, Integer>> countOrderNumByPt(@Param("year") int year);

    /**
     * 统计每月退款呢订单
     * @return
     */
    List<Map<String, Integer>> countOrderNumByTk(@Param("year") int year);

}
