package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterOrderLog;

import java.util.List;

/**
 * 订单日志Mapper接口
 * 
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterOrderLogMapper 
{
    /**
     * 查询订单日志
     * 
     * @param id 订单日志主键
     * @return 订单日志
     */
    public WaterOrderLog selectWaterOrderLogById(Long id);

    /**
     * 查询订单日志列表
     * 
     * @param waterOrderLog 订单日志
     * @return 订单日志集合
     */
    public List<WaterOrderLog> selectWaterOrderLogList(WaterOrderLog waterOrderLog);

    /**
     * 新增订单日志
     * 
     * @param waterOrderLog 订单日志
     * @return 结果
     */
    public int insertWaterOrderLog(WaterOrderLog waterOrderLog);

    /**
     * 修改订单日志
     * 
     * @param waterOrderLog 订单日志
     * @return 结果
     */
    public int updateWaterOrderLog(WaterOrderLog waterOrderLog);

    /**
     * 删除订单日志
     * 
     * @param id 订单日志主键
     * @return 结果
     */
    public int deleteWaterOrderLogById(Long id);

    /**
     * 批量删除订单日志
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterOrderLogByIds(Long[] ids);
}
