package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterOrderGoods;

import java.util.List;

/**
 * 订单商品Mapper接口
 * 
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterOrderGoodsMapper 
{
    /**
     * 查询订单商品
     * 
     * @param id 订单商品主键
     * @return 订单商品
     */
    public WaterOrderGoods selectWaterOrderGoodsById(Long id);

    /**
     * 查询订单商品列表
     * 
     * @param waterOrderGoods 订单商品
     * @return 订单商品集合
     */
    public List<WaterOrderGoods> selectWaterOrderGoodsList(WaterOrderGoods waterOrderGoods);

    /**
     * 新增订单商品
     * 
     * @param waterOrderGoods 订单商品
     * @return 结果
     */
    public int insertWaterOrderGoods(WaterOrderGoods waterOrderGoods);

    /**
     * 修改订单商品
     * 
     * @param waterOrderGoods 订单商品
     * @return 结果
     */
    public int updateWaterOrderGoods(WaterOrderGoods waterOrderGoods);

    /**
     * 删除订单商品
     * 
     * @param id 订单商品主键
     * @return 结果
     */
    public int deleteWaterOrderGoodsById(Long id);

    /**
     * 批量删除订单商品
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterOrderGoodsByIds(Long[] ids);
}
