package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterGoodsType;

import java.util.List;

/**
 * 商品分类Mapper接口
 * 
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterGoodsTypeMapper 
{
    /**
     * 查询商品分类
     * 
     * @param id 商品分类主键
     * @return 商品分类
     */
    public WaterGoodsType selectWaterGoodsTypeById(Long id);

    /**
     * 查询商品分类列表
     * 
     * @param waterGoodsType 商品分类
     * @return 商品分类集合
     */
    public List<WaterGoodsType> selectWaterGoodsTypeList(WaterGoodsType waterGoodsType);

    /**
     * 新增商品分类
     * 
     * @param waterGoodsType 商品分类
     * @return 结果
     */
    public int insertWaterGoodsType(WaterGoodsType waterGoodsType);

    /**
     * 修改商品分类
     * 
     * @param waterGoodsType 商品分类
     * @return 结果
     */
    public int updateWaterGoodsType(WaterGoodsType waterGoodsType);

    /**
     * 删除商品分类
     * 
     * @param id 商品分类主键
     * @return 结果
     */
    public int deleteWaterGoodsTypeById(Long id);

    /**
     * 批量删除商品分类
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterGoodsTypeByIds(Long[] ids);
}
