package com.qianhe.system.mapper;

import com.qianhe.system.domain.WaterGoodsSpe;
import com.qianhe.system.domain.WaterGoodsSpeVal;
import com.qianhe.system.vo.WaterGoodsSpeVo;

import java.util.List;

/**
 * 商品关联规格Mapper接口
 *
 * @author qianhe
 * @date 2023-11-23
 */
public interface WaterGoodsSpeMapper
{
    /**
     * 查询商品关联规格
     *
     * @param id 商品关联规格主键
     * @return 商品关联规格
     */
    public WaterGoodsSpe selectWaterGoodsSpeById(Long id);

    /**
     * 查询商品关联规格值
     *
     * @param id 商品关联规格值主键
     * @return 商品关联规格值
     */
    public WaterGoodsSpeVal selectWaterGoodsSpeValById(String id);

    /**
     * 查询商品关联规格列表
     *
     * @param waterGoodsSpe 商品关联规格
     * @return 商品关联规格集合
     */
    public List<WaterGoodsSpe> selectWaterGoodsSpeList(WaterGoodsSpe waterGoodsSpe);

    /**
     * 查询商品关联规格值列表
     *
     * @param waterGoodsSpeVal 商品关联规格值
     * @return 商品关联规格值集合
     */
    public List<WaterGoodsSpeVal> selectWaterGoodsSpeValList(WaterGoodsSpeVal waterGoodsSpeVal);

    /**
     * 新增商品关联规格
     *
     * @param waterGoodsSpeVo 商品关联规格
     * @return 结果
     */
    public int insertWaterGoodsSpe(WaterGoodsSpeVo waterGoodsSpeVo);

    /**
     * 修改商品关联规格
     *
     * @param waterGoodsSpeVo 商品关联规格
     * @return 结果
     */
    public int updateWaterGoodsSpe(WaterGoodsSpeVo waterGoodsSpeVo);

    /**
     * 删除商品关联规格
     *
     * @param id 商品关联规格主键
     * @return 结果
     */
    public int deleteWaterGoodsSpeById(Long id);

    /**
     * 批量删除商品关联规格
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterGoodsSpeByIds(Long[] ids);

    /**
     * 删除商品关联规格值
     *
     * @param id 商品关联规格主键
     * @return 结果
     */
    public int deleteWaterGoodsSpeValBySpeId(Long id);

    /**
     * 批量删除商品关联规格值
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWaterGoodsSpeValBySpeIds(Long[] ids);

    /**
     * 批量新增商品关联规格值
     * @param list
     * @return
     */
    int batchInsertWaterGoodsSpeVal(List<WaterGoodsSpeVal> list);
}
